/*
 * Decompiled with CFR 0.152.
 */
package org.noear.grit.client;

import org.noear.grit.client.GritClient;
import org.noear.grit.client.utils.EncryptUtils;
import org.noear.grit.client.utils.TextUtils;
import org.noear.grit.model.domain.Resource;
import org.noear.grit.model.domain.ResourceSpace;

public class GritUtil {
    protected static GritClient client;

    public static String buildPassword(String longName, String loginPassword) {
        return EncryptUtils.sha1(longName + "#" + loginPassword);
    }

    public static String buildDockUri(Resource res) {
        if (res == null || TextUtils.isEmpty(res.link_uri)) {
            return "";
        }
        if (res.link_uri.indexOf("/$") > 0) {
            if (res.is_fullview.booleanValue()) {
                return res.link_uri + "?@=";
            }
            return res.link_uri;
        }
        if (res.is_fullview.booleanValue()) {
            return res.link_uri + "/@" + res.display_name + "?@=";
        }
        return res.link_uri + "/@" + res.display_name;
    }

    public static String buildDockSpaceUri(ResourceSpace space, Resource res) {
        if (res == null || TextUtils.isEmpty(res.link_uri)) {
            return "";
        }
        if (res.link_uri.indexOf("/$") > 0) {
            if (res.is_fullview.booleanValue()) {
                return "/." + space.resource_code + res.link_uri + "?@=";
            }
            return "/." + space.resource_code + res.link_uri;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("/.").append(space.resource_code).append(res.link_uri).append("/@").append(res.display_name);
        if (res.is_fullview.booleanValue()) {
            sb.append("?@=");
        }
        if (res.remark != null && res.remark.indexOf("://") > 0) {
            if (sb.indexOf("?") > 0) {
                sb.append("&__r=").append(res.resource_id);
            } else {
                sb.append("?__r=").append(res.resource_id);
            }
        }
        return sb.toString();
    }

    public static String parseSpaceCodeByPath(String path) {
        int start_idx = path.indexOf(".");
        if (start_idx == 1) {
            int end_idx = path.indexOf("/", ++start_idx);
            return path.substring(start_idx, end_idx);
        }
        return "";
    }

    public static String cleanSpaceCodeAtPath(String path) {
        return path.replaceAll("/\\.[^/]*", "");
    }
}

