/*
 * Decompiled with CFR 0.152.
 */
package org.noear.grit.client.utils;

import java.security.Key;
import java.security.MessageDigest;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.noear.grit.client.utils.Base64Utils;
import org.noear.grit.client.utils.TextUtils;

public class EncryptUtils {
    public static String sha1(String cleanData) {
        return EncryptUtils.hashEncode("SHA-1", cleanData);
    }

    public static String md5(String cleanData) {
        return EncryptUtils.hashEncode("MD5", cleanData);
    }

    private static String hashEncode(String algorithm, String cleanData) {
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        try {
            byte[] btInput = cleanData.getBytes("UTF-16LE");
            MessageDigest mdInst = MessageDigest.getInstance(algorithm);
            mdInst.update(btInput);
            byte[] md = mdInst.digest();
            int j = md.length;
            char[] str = new char[j * 2];
            int k = 0;
            for (int i = 0; i < j; ++i) {
                byte byte0 = md[i];
                str[k++] = hexDigits[byte0 >>> 4 & 0xF];
                str[k++] = hexDigits[byte0 & 0xF];
            }
            return new String(str);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String aesEncrypt(String content, String password) throws Exception {
        return EncryptUtils.aesEncrypt(content, password, null);
    }

    public static String aesEncrypt(String content, String password, String algorithm) throws Exception {
        return EncryptUtils.aesEncrypt(content, password, algorithm, null);
    }

    public static String aesEncrypt(String content, String password, String algorithm, String offset) throws Exception {
        return EncryptUtils.aesEncrypt(content, password, algorithm, offset, null);
    }

    public static String aesEncrypt(String content, String password, String algorithm, String offset, String charset) throws Exception {
        if (TextUtils.isEmpty(algorithm)) {
            algorithm = "AES/ECB/PKCS5Padding";
        }
        if (TextUtils.isEmpty(charset)) {
            charset = "UTF-8";
        }
        byte[] pswd = password.getBytes(charset);
        SecretKeySpec secretKey = new SecretKeySpec(pswd, "AES");
        Cipher cipher = Cipher.getInstance(algorithm);
        if (TextUtils.isEmpty(offset)) {
            cipher.init(1, secretKey);
        } else {
            IvParameterSpec iv = new IvParameterSpec(offset.getBytes(charset));
            cipher.init(1, (Key)secretKey, iv);
        }
        byte[] encrypted = cipher.doFinal(content.getBytes(charset));
        return Base64Utils.encodeByte(encrypted);
    }

    public static String aesDecrypt(String content, String password) throws Exception {
        return EncryptUtils.aesDecrypt(content, password, null);
    }

    public static String aesDecrypt(String content, String password, String algorithm) throws Exception {
        return EncryptUtils.aesDecrypt(content, password, algorithm, null);
    }

    public static String aesDecrypt(String content, String password, String algorithm, String offset) throws Exception {
        return EncryptUtils.aesDecrypt(content, password, algorithm, offset, null);
    }

    public static String aesDecrypt(String content, String password, String algorithm, String offset, String charset) throws Exception {
        if (TextUtils.isEmpty(algorithm)) {
            algorithm = "AES/ECB/PKCS5Padding";
        }
        if (TextUtils.isEmpty(charset)) {
            charset = "UTF-8";
        }
        byte[] pswd = password.getBytes(charset);
        SecretKeySpec secretKey = new SecretKeySpec(pswd, "AES");
        Cipher cipher = Cipher.getInstance(algorithm);
        if (TextUtils.isEmpty(offset)) {
            cipher.init(2, secretKey);
        } else {
            IvParameterSpec iv = new IvParameterSpec(offset.getBytes(charset));
            cipher.init(2, (Key)secretKey, iv);
        }
        byte[] encrypted1 = Base64Utils.decodeByte(content);
        byte[] original = cipher.doFinal(encrypted1);
        return new String(original, charset);
    }
}

