/*
 * Decompiled with CFR 0.152.
 */
package org.noear.grit.service;

import java.sql.SQLException;
import java.util.List;
import org.noear.grit.client.GritClient;
import org.noear.grit.model.domain.ResourceEntity;
import org.noear.grit.model.domain.ResourceGroup;
import org.noear.grit.model.domain.ResourceSpace;
import org.noear.grit.model.domain.Subject;
import org.noear.grit.model.domain.SubjectGroup;

public interface AuthService {
    public Subject login(String var1, String var2) throws Exception;

    public boolean hasUriBySpace(long var1, long var3, String var5) throws SQLException;

    default public boolean hasUri(long subjectId, String uri) throws SQLException {
        return this.hasUriBySpace(subjectId, GritClient.global().getCurrentSpaceId(), uri);
    }

    public boolean hasPermissionBySpace(long var1, long var3, String var5) throws SQLException;

    default public boolean hasPermission(long subjectId, String permission) throws SQLException {
        return this.hasPermissionBySpace(subjectId, GritClient.global().getCurrentSpaceId(), permission);
    }

    public boolean hasRole(long var1, String var3) throws SQLException;

    public List<ResourceEntity> getResListByGroup(long var1, long var3) throws SQLException;

    public List<ResourceEntity> getResListByGroupCode(long var1, String var3) throws SQLException;

    public List<ResourceEntity> getUriListByGroup(long var1, long var3) throws SQLException;

    public List<ResourceEntity> getUriListBySpace(long var1, long var3) throws SQLException;

    default public List<ResourceEntity> getUriList(long subjectId) throws SQLException {
        return this.getUriListBySpace(subjectId, GritClient.global().getCurrentSpaceId());
    }

    public ResourceEntity getUriFristBySpace(long var1, long var3) throws SQLException;

    default public ResourceEntity getUriFrist(long subjectId) throws SQLException {
        return this.getUriFristBySpace(subjectId, GritClient.global().getCurrentSpaceId());
    }

    public ResourceEntity getUriFristByGroup(long var1, long var3) throws SQLException;

    public List<ResourceGroup> getUriGroupListBySpace(long var1, long var3) throws SQLException;

    default public List<ResourceGroup> getUriGroupList(long subjectId) throws SQLException {
        return this.getUriGroupListBySpace(subjectId, GritClient.global().getCurrentSpaceId());
    }

    public List<ResourceEntity> getPermissionListBySpace(long var1, long var3) throws SQLException;

    default public List<ResourceEntity> getPermissionList(long subjectId) throws SQLException {
        return this.getPermissionListBySpace(subjectId, GritClient.global().getCurrentSpaceId());
    }

    public List<SubjectGroup> getRoleList(long var1) throws SQLException;

    public List<ResourceSpace> getSpaceList(long var1) throws SQLException;

    public ResourceSpace getSpaceFrist(long var1) throws SQLException;
}

