/*
 * Decompiled with CFR 0.152.
 */
package org.noear.grit.service;

import java.sql.SQLException;
import java.util.List;
import org.noear.grit.client.GritClient;
import org.noear.grit.model.domain.Resource;
import org.noear.grit.model.domain.ResourceEntity;
import org.noear.grit.model.domain.ResourceSpace;

public interface ResourceService {
    public Resource getResourceById(long var1) throws SQLException;

    public Resource getResourceByGuid(long var1) throws SQLException;

    public boolean hasResourceByGuid(long var1) throws SQLException;

    public Resource getResourceByCodeAndSpace(long var1, String var3) throws SQLException;

    default public Resource getResourceByCode(String resourceCode) throws SQLException {
        return this.getResourceByCodeAndSpace(GritClient.global().getCurrentSpaceId(), resourceCode);
    }

    public Resource getResourceByUriAndSpace(long var1, String var3) throws SQLException;

    default public Resource getResourceByUri(String resourceUri) throws SQLException {
        return this.getResourceByUriAndSpace(GritClient.global().getCurrentSpaceId(), resourceUri);
    }

    public boolean hasResourceByCodeAndSpace(long var1, String var3) throws SQLException;

    default public boolean hasResourceByCode(String resourceCode) throws SQLException {
        return this.hasResourceByCodeAndSpace(GritClient.global().getCurrentSpaceId(), resourceCode);
    }

    public boolean hasResourceByUriAndSpace(long var1, String var3) throws SQLException;

    default public boolean hasResourceByUri(String resourceUri) throws SQLException {
        return this.hasResourceByUriAndSpace(GritClient.global().getCurrentSpaceId(), resourceUri);
    }

    public List<Resource> getSubResourceListByPid(long var1) throws SQLException;

    public List<ResourceEntity> getSubResourceEngityListByPid(long var1) throws SQLException;

    public ResourceSpace getSpaceByCode(String var1) throws SQLException;

    public boolean hasSpaceByCode(String var1) throws SQLException;

    public List<ResourceSpace> getSpaceList() throws SQLException;
}

