/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.solon.boot;

import java.io.IOException;
import net.hasor.core.AppContext;
import net.hasor.core.Module;
import net.hasor.solon.boot.BuildConfig;
import net.hasor.solon.boot.EnableHasor;
import net.hasor.solon.boot.EnableHasorWeb;
import net.hasor.solon.boot.Property;
import net.hasor.utils.ExceptionUtils;
import net.hasor.utils.StringUtils;
import org.noear.solon.Solon;
import org.noear.solon.annotation.Configuration;
import org.noear.solon.annotation.Inject;
import org.noear.solon.core.bean.InitializingBean;

@Configuration
public class HasorConfiguration
implements InitializingBean {
    @Inject
    private org.noear.solon.core.AppContext context;

    public void afterInjection() throws Throwable {
        Property[] customProperties;
        EnableHasor enableHasor = Solon.app().source().getAnnotation(EnableHasor.class);
        BuildConfig buildConfig = BuildConfig.getInstance();
        buildConfig.mainConfig = enableHasor.mainConfig();
        buildConfig.useProperties = enableHasor.useProperties();
        for (Class<? extends Module> startWith : enableHasor.startWith()) {
            if (startWith.getAnnotations().length > 0) {
                this.context.getWrapAsync(startWith, bw -> buildConfig.addModules((Module)bw.get()));
                continue;
            }
            buildConfig.addModules((Module)this.context.getBeanOrNew(startWith));
        }
        if (enableHasor.scanPackages().length != 0) {
            for (String p : enableHasor.scanPackages()) {
                if (p.endsWith(".*")) {
                    this.context.beanScan(p.substring(0, p.length() - 2));
                    continue;
                }
                this.context.beanScan(p);
            }
        }
        for (Property property : customProperties = enableHasor.customProperties()) {
            String name = property.name();
            if (!StringUtils.isNotBlank((String)name)) continue;
            buildConfig.customProperties.put(name, property.value());
        }
        if (Solon.app().source().getAnnotation(EnableHasorWeb.class) == null) {
            this.context.wrapAndPut(AppContext.class, (Object)this.initAppContext());
        }
    }

    private AppContext initAppContext() {
        try {
            return BuildConfig.getInstance().build(null);
        }
        catch (IOException e) {
            throw ExceptionUtils.toRuntimeException((Throwable)e);
        }
    }
}

