/*
 * Decompiled with CFR 0.152.
 */
package com.fujieid.jap.solon.http.controller;

import com.fujieid.jap.core.JapUser;
import com.fujieid.jap.core.context.JapAuthentication;
import com.fujieid.jap.http.JapHttpRequest;
import com.fujieid.jap.http.JapHttpResponse;
import com.fujieid.jap.http.adapter.jakarta.JakartaRequestAdapter;
import com.fujieid.jap.http.adapter.jakarta.JakartaResponseAdapter;
import com.fujieid.jap.solon.HttpServletRequestWrapperImpl;
import com.fujieid.jap.solon.JapProps;
import com.fujieid.jap.solon.http.controller.JapController;
import com.fujieid.jap.sso.JapMfa;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.noear.solon.annotation.Get;
import org.noear.solon.annotation.Inject;
import org.noear.solon.annotation.Mapping;
import org.noear.solon.annotation.Post;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.DownloadedFile;

public class MfaController
extends JapController {
    @Inject
    JapProps japProperties;
    @Inject
    JapMfa japMfa;

    @Get
    @Mapping(value="/mfa/generate")
    public Object generate(String type, Context ctx, HttpServletRequest request, HttpServletResponse response) throws FileNotFoundException, IllegalAccessException {
        JapUser japUser = JapAuthentication.getUser((JapHttpRequest)new JakartaRequestAdapter((HttpServletRequest)new HttpServletRequestWrapperImpl(ctx, request)), (JapHttpResponse)new JakartaResponseAdapter(response));
        if (japUser == null) {
            throw new IllegalAccessException();
        }
        switch (type) {
            case "file": {
                File qrcode = this.japMfa.getOtpQrcodeFile(japUser.getUsername(), this.japProperties.getIssuer());
                return new DownloadedFile("image/png", (InputStream)new FileInputStream(qrcode), qrcode.getName());
            }
            case "base64": {
                return this.japMfa.getOtpQrcodeFileBase64(japUser.getUsername(), this.japProperties.getIssuer(), true);
            }
            case "url": {
                return this.japMfa.getOtpQrCodeUrl(japUser.getUsername(), this.japProperties.getIssuer());
            }
        }
        this.japMfa.createOtpQrcode(japUser.getUsername(), this.japProperties.getIssuer(), (JapHttpResponse)new JakartaResponseAdapter(response));
        return null;
    }

    @Post
    @Mapping(value="/mfa/verify")
    public boolean verify(Context ctx, String username, String secretKey, int otpCode) throws FileNotFoundException {
        boolean result = false;
        if (username != null) {
            result = this.japMfa.verifyByUsername(username, otpCode);
        } else if (secretKey != null) {
            result = this.japMfa.verifyBySecret(secretKey, otpCode);
        } else {
            throw new IllegalArgumentException();
        }
        ctx.sessionSet("_jap:mfaVerified", (Object)result);
        return result;
    }
}

