/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.kafka.impl;

import java.util.Properties;
import java.util.function.BiConsumer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudProps;

public class KafkaConfig {
    private final CloudProps cloudProps;
    private final String server;
    private final long publishTimeout;
    private final String eventChannel;
    private final String eventGroup;

    public long getPublishTimeout() {
        return this.publishTimeout;
    }

    public String getEventChannel() {
        return this.eventChannel;
    }

    public String getEventGroup() {
        return this.eventGroup;
    }

    public KafkaConfig(CloudProps cloudProps) {
        this.cloudProps = cloudProps;
        this.server = cloudProps.getEventServer();
        this.publishTimeout = cloudProps.getEventPublishTimeout();
        this.eventChannel = cloudProps.getEventChannel();
        this.eventGroup = cloudProps.getEventGroup();
    }

    public Properties getProducerProperties(boolean forTran) {
        Properties properties = new Properties();
        properties.put("bootstrap.servers", this.server);
        properties.put("key.serializer", StringSerializer.class.getName());
        properties.put("value.serializer", StringSerializer.class.getName());
        properties.put("acks", "all");
        properties.put("batch.size", (Object)16384);
        if (forTran) {
            properties.put("retries", (Object)1);
            properties.put("enable.idempotence", (Object)true);
            properties.put("transactional.id", Utils.guid());
        } else {
            properties.put("retries", (Object)0);
        }
        Properties props = this.cloudProps.getEventProducerProps();
        if (props.size() > 0) {
            props.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> properties.put(k, v)));
        }
        return properties;
    }

    public Properties getConsumerProperties() {
        Properties properties = new Properties();
        properties.put("bootstrap.servers", this.server);
        properties.put("key.deserializer", StringDeserializer.class.getName());
        properties.put("value.deserializer", StringDeserializer.class.getName());
        properties.put("group.id", Solon.cfg().appGroup() + "_" + Solon.cfg().appName());
        properties.put("enable.auto.commit", "false");
        properties.put("isolation.level", "read_committed");
        properties.put("session.timeout.ms", (Object)30000);
        properties.put("max.poll.interval.ms", (Object)30000);
        properties.put("max.poll.records", (Object)100);
        properties.put("auto.offset.reset", "earliest");
        Properties props = this.cloudProps.getEventConsumerProps();
        if (props.size() > 0) {
            props.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> properties.put(k, v)));
        }
        return properties;
    }
}

