/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.kafka.service;

import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Properties;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.TopicPartition;
import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudEventHandler;
import org.noear.solon.cloud.CloudProps;
import org.noear.solon.cloud.annotation.EventLevel;
import org.noear.solon.cloud.exception.CloudEventException;
import org.noear.solon.cloud.extend.kafka.impl.KafkaConfig;
import org.noear.solon.cloud.extend.kafka.impl.KafkaTransactionListener;
import org.noear.solon.cloud.model.Event;
import org.noear.solon.cloud.model.EventObserver;
import org.noear.solon.cloud.model.EventTran;
import org.noear.solon.cloud.model.EventTranListener;
import org.noear.solon.cloud.service.CloudEventObserverManger;
import org.noear.solon.cloud.service.CloudEventServicePlus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudEventServiceKafkaImpl
implements CloudEventServicePlus,
Closeable {
    private static final Logger log = LoggerFactory.getLogger(CloudEventServiceKafkaImpl.class);
    private final KafkaConfig config;
    private KafkaProducer<String, String> producer;
    private KafkaProducer<String, String> producerTran;
    private KafkaConsumer<String, String> consumer;
    private Thread consumerThread;
    CloudEventObserverManger observerManger = new CloudEventObserverManger();

    public CloudEventServiceKafkaImpl(CloudProps cloudProps) {
        this.config = new KafkaConfig(cloudProps);
    }

    private void initProducer() {
        if (this.producer != null) {
            return;
        }
        Utils.locker().lock();
        try {
            if (this.producer != null) {
                return;
            }
            this.producer = new KafkaProducer(this.config.getProducerProperties(false));
            this.producerTran = new KafkaProducer(this.config.getProducerProperties(true));
            this.producerTran.initTransactions();
        }
        finally {
            Utils.locker().unlock();
        }
    }

    private void initConsumer() {
        if (this.consumer != null) {
            return;
        }
        Utils.locker().lock();
        try {
            if (this.consumer != null) {
                return;
            }
            Properties properties = this.config.getConsumerProperties();
            this.consumer = new KafkaConsumer(properties);
        }
        finally {
            Utils.locker().unlock();
        }
    }

    private void beginTransaction(EventTran transaction) throws CloudEventException {
        if (transaction.getListener(KafkaTransactionListener.class) != null) {
            return;
        }
        try {
            this.producerTran.beginTransaction();
            transaction.setListener((EventTranListener)new KafkaTransactionListener(this.producerTran));
        }
        catch (Exception e) {
            throw new CloudEventException((Throwable)e);
        }
    }

    public boolean publish(Event event) throws CloudEventException {
        this.initProducer();
        if (Utils.isEmpty((String)event.key())) {
            event.key(Utils.guid());
        }
        if (event.tran() != null) {
            this.beginTransaction(event.tran());
        }
        Future future = null;
        ProducerRecord record = new ProducerRecord(event.topic(), (Object)event.key(), (Object)event.content());
        future = event.tran() == null ? this.producer.send(record) : this.producerTran.send(record);
        if (this.config.getPublishTimeout() > 0L && event.qos() > 0) {
            try {
                future.get(this.config.getPublishTimeout(), TimeUnit.MILLISECONDS);
            }
            catch (Exception e) {
                throw new CloudEventException((Throwable)e);
            }
        }
        return true;
    }

    public void attention(EventLevel level, String channel, String group, String topic, String tag, int qos, CloudEventHandler observer) {
        this.observerManger.add(topic, level, group, topic, tag, qos, observer);
    }

    public void subscribe() {
        if (this.consumerThread == null && this.observerManger.topicSize() > 0) {
            try {
                this.initConsumer();
                this.consumer.subscribe((Collection)this.observerManger.topicAll());
                this.consumerThread = new Thread(this::subscribePull);
                this.consumerThread.start();
            }
            catch (Throwable ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    private void subscribePull() {
        while (!this.consumerThread.isInterrupted()) {
            try {
                this.subscribePullDo();
            }
            catch (EOFException e) {
                break;
            }
            catch (Throwable e) {
                log.warn(e.getMessage(), e);
            }
        }
    }

    private void subscribePullDo() throws Throwable {
        ConsumerRecords records = this.consumer.poll(Duration.ofMillis(100L));
        if (records.isEmpty()) {
            Thread.sleep(100L);
            return;
        }
        LinkedHashMap<TopicPartition, OffsetAndMetadata> topicOffsets = new LinkedHashMap<TopicPartition, OffsetAndMetadata>();
        try {
            ConsumerRecord record;
            Event event;
            Iterator iterator = records.iterator();
            while (iterator.hasNext() && this.onReceive(event = new Event((record = (ConsumerRecord)iterator.next()).topic(), (String)record.value()).key((String)record.key()).channel(this.config.getEventChannel()))) {
                topicOffsets.put(new TopicPartition(record.topic(), record.partition()), new OffsetAndMetadata(record.offset() + 1L));
            }
        }
        catch (Throwable e) {
            log.warn(e.getMessage(), e);
        }
        if (topicOffsets.size() > 0) {
            this.consumer.commitAsync(topicOffsets, null);
        }
    }

    public boolean onReceive(Event event) throws Throwable {
        boolean isOk = true;
        EventObserver handler = null;
        handler = this.observerManger.getByTopic(event.topic());
        if (handler != null) {
            isOk = handler.handle(event);
        } else {
            log.warn("There is no observer for this event topic[{}]", (Object)event.topic());
        }
        return isOk;
    }

    public String getChannel() {
        return this.config.getEventChannel();
    }

    public String getGroup() {
        return this.config.getEventGroup();
    }

    @Override
    public void close() throws IOException {
        if (this.producer != null) {
            this.producer.close();
        }
        if (this.producerTran != null) {
            this.producerTran.close();
        }
        if (this.consumer != null) {
            this.consumer.close();
        }
        if (this.consumerThread != null) {
            this.consumerThread.interrupt();
        }
    }
}

