/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.io;

import java.io.IOException;
import org.beetl.core.ByteWriter;
import org.beetl.core.io.IntIOWriter;

public class LongIOWriter {
    public static void writeLong(ByteWriter bw, Long i) throws IOException {
        if (i == Long.MIN_VALUE) {
            bw.writeString("-9223372036854775808");
            return;
        }
        int size = i < 0L ? LongIOWriter.stringSize(-i.longValue()) + 1 : LongIOWriter.stringSize(i);
        char[] buf = bw.getLocalBuffer().getCharBuffer();
        LongIOWriter.getChars(i, size, buf);
        bw.writeNumberChars(buf, size);
    }

    static void getChars(long i, int index, char[] buf) {
        int q2;
        int r;
        int charPos = index;
        int sign = 0;
        if (i < 0L) {
            sign = 45;
            i = -i;
        }
        while (i > Integer.MAX_VALUE) {
            long q = i / 100L;
            r = (int)(i - ((q << 6) + (q << 5) + (q << 2)));
            i = q;
            buf[--charPos] = IntIOWriter.DigitOnes[r];
            buf[--charPos] = IntIOWriter.DigitTens[r];
        }
        int i2 = (int)i;
        while (i2 >= 65536) {
            q2 = i2 / 100;
            r = i2 - ((q2 << 6) + (q2 << 5) + (q2 << 2));
            i2 = q2;
            buf[--charPos] = IntIOWriter.DigitOnes[r];
            buf[--charPos] = IntIOWriter.DigitTens[r];
        }
        do {
            q2 = i2 * 52429 >>> 19;
            r = i2 - ((q2 << 3) + (q2 << 1));
            buf[--charPos] = IntIOWriter.digits[r];
        } while ((i2 = q2) != 0);
        if (sign != 0) {
            buf[--charPos] = sign;
        }
    }

    static int stringSize(long x) {
        long p = 10L;
        for (int i = 1; i < 19; ++i) {
            if (x < p) {
                return i;
            }
            p = 10L * p;
        }
        return 19;
    }
}

