/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.statement;

import java.util.Map;
import org.beetl.core.Context;
import org.beetl.core.Function;
import org.beetl.core.GroupTemplate;
import org.beetl.core.Resource;
import org.beetl.core.exception.BeetlException;
import org.beetl.core.fun.FileFunctionWrapper;
import org.beetl.core.statement.Expression;
import org.beetl.core.statement.GrammarToken;
import org.beetl.core.statement.VarAttribute;

public class FunctionExpression
extends Expression {
    String name;
    public Expression[] exps;
    public VarAttribute[] vas;
    public Expression safeExp;
    boolean hasSafe = false;

    public FunctionExpression(String name, Expression[] exps, VarAttribute[] vas, boolean hasSafe, Expression safeExp, GrammarToken token) {
        super(token);
        this.name = name;
        this.exps = exps;
        this.vas = vas;
        this.safeExp = safeExp;
        this.hasSafe = hasSafe;
    }

    @Override
    public Object evaluate(Context ctx) {
        Function fn = ctx.gt.getFunction(this.name);
        if (fn == null) {
            Resource resource = this.getResource(ctx.gt, this.name);
            if (resource.getResourceLoader().exist(resource.getId())) {
                fn = new FileFunctionWrapper(resource.getId());
            } else {
                BeetlException ex = new BeetlException("FUNCTION_NOT_FOUND");
                ex.pushToken(this.token);
                throw ex;
            }
        }
        Object[] paras = new Object[this.exps.length];
        for (int i = 0; i < paras.length; ++i) {
            paras[i] = this.exps[i].evaluate(ctx);
        }
        Object value = null;
        try {
            value = fn.call(paras, ctx);
        }
        catch (BeetlException ex) {
            ex.pushToken(this.token);
            throw ex;
        }
        catch (RuntimeException ex) {
            BeetlException be = new BeetlException("NATIVE_CALL_EXCEPTION", "\u8c03\u7528\u65b9\u6cd5\u51fa\u9519 " + this.name, ex);
            be.pushToken(this.token);
            throw be;
        }
        Object ret = null;
        if (this.vas == null) {
            ret = value;
        } else {
            for (VarAttribute attr : this.vas) {
                try {
                    value = attr.evaluate(ctx, value);
                }
                catch (BeetlException ex) {
                    ex.pushToken(attr.token);
                    throw ex;
                }
                catch (RuntimeException ex) {
                    BeetlException be = new BeetlException("ATTRIBUTE_INVALID", "\u5c5e\u6027\u8bbf\u95ee\u51fa\u9519", ex);
                    be.pushToken(attr.token);
                    throw be;
                }
                if (value != null) continue;
                if (this.hasSafe) {
                    return this.safeExp == null ? null : this.safeExp.evaluate(ctx);
                }
                BeetlException be = new BeetlException("ERROR", "\u7a7a\u6307\u9488 ");
                be.pushToken(attr.token);
                throw be;
            }
            ret = value;
        }
        if (ret == null && this.hasSafe) {
            return this.safeExp == null ? null : this.safeExp.evaluate(ctx);
        }
        return ret;
    }

    private Resource getResource(GroupTemplate gt, String name) {
        Map<String, String> resourceMap = gt.getConf().getResourceMap();
        String functionSuffix = resourceMap.get("functionSuffix");
        String functionRoot = resourceMap.get("functionRoot");
        String path = name.replace(".", "/");
        Resource resource = gt.getResourceLoader().getResource(functionRoot + "/" + path + "." + functionSuffix);
        return resource;
    }
}

