/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.template.expr.ast;

import com.jfinal.kit.SyncWriteMap;
import com.jfinal.template.expr.ast.FastFieldGetter;
import com.jfinal.template.expr.ast.FieldGetter;
import com.jfinal.template.expr.ast.FieldGetters;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;

public class FieldKit {
    private static FieldGetter[] getters = FieldKit.init();
    private static final HashMap<Object, FieldGetter> fieldGetterCache = new SyncWriteMap<Object, FieldGetter>(1024, 0.25f);

    private static FieldGetter[] init() {
        LinkedList<FieldGetter> ret = new LinkedList<FieldGetter>();
        ret.addLast(new FieldGetters.GetterMethodFieldGetter(null));
        ret.addLast(new FieldGetters.RealFieldGetter(null));
        ret.addLast(new FieldGetters.MapFieldGetter());
        ret.addLast(new FieldGetters.ArrayLengthGetter());
        return ret.toArray(new FieldGetter[ret.size()]);
    }

    public static FieldGetter getFieldGetter(Object key, Class<?> targetClass, String fieldName) {
        FieldGetter fieldGetter = fieldGetterCache.get(key);
        if (fieldGetter == null) {
            fieldGetter = FieldKit.doGetFieldGetter(targetClass, fieldName);
            fieldGetterCache.putIfAbsent(key, fieldGetter);
        }
        return fieldGetter;
    }

    private static FieldGetter doGetFieldGetter(Class<?> targetClass, String fieldName) {
        for (FieldGetter fieldGetter : getters) {
            FieldGetter ret = fieldGetter.takeOver(targetClass, fieldName);
            if (ret == null) continue;
            return ret;
        }
        return FieldGetters.NullFieldGetter.me;
    }

    public static void addFieldGetter(int index, FieldGetter fieldGetter) {
        FieldKit.addFieldGetter(fieldGetter, index, true);
    }

    public static void addFieldGetterToLast(FieldGetter fieldGetter) {
        FieldKit.addFieldGetter(fieldGetter, null, true);
    }

    public static void addFieldGetterToFirst(FieldGetter fieldGetter) {
        FieldKit.addFieldGetter(fieldGetter, null, false);
    }

    private static synchronized void addFieldGetter(FieldGetter fieldGetter, Integer index, boolean addLast) {
        FieldKit.checkParameter(fieldGetter);
        LinkedList<FieldGetter> ret = FieldKit.getCurrentFieldGetters();
        if (index != null) {
            ret.add(index, fieldGetter);
        } else if (addLast) {
            ret.addLast(fieldGetter);
        } else {
            ret.addFirst(fieldGetter);
        }
        getters = ret.toArray(new FieldGetter[ret.size()]);
    }

    private static LinkedList<FieldGetter> getCurrentFieldGetters() {
        LinkedList<FieldGetter> ret = new LinkedList<FieldGetter>();
        for (FieldGetter fieldGetter : getters) {
            ret.add(fieldGetter);
        }
        return ret;
    }

    private static void checkParameter(FieldGetter fieldGetter) {
        if (fieldGetter == null) {
            throw new IllegalArgumentException("The parameter fieldGetter can not be null");
        }
        for (FieldGetter fg : getters) {
            if (fg.getClass() != fieldGetter.getClass()) continue;
            throw new RuntimeException("FieldGetter already exists : " + fieldGetter.getClass().getName());
        }
    }

    public static synchronized void removeFieldGetter(Class<? extends FieldGetter> fieldGetterClass) {
        LinkedList<FieldGetter> ret = FieldKit.getCurrentFieldGetters();
        Iterator it = ret.iterator();
        while (it.hasNext()) {
            if (((FieldGetter)it.next()).getClass() != fieldGetterClass) continue;
            it.remove();
        }
        getters = ret.toArray(new FieldGetter[ret.size()]);
    }

    public static void clearCache() {
        fieldGetterCache.clear();
    }

    public static synchronized void setFastMode(boolean fastMode) {
        if (fastMode) {
            if (!FieldKit.contains(FastFieldGetter.class)) {
                FieldKit.addFieldGetterToFirst(new FastFieldGetter());
            }
        } else if (FieldKit.contains(FastFieldGetter.class)) {
            FieldKit.removeFieldGetter(FastFieldGetter.class);
        }
    }

    public static boolean contains(Class<? extends FieldGetter> fieldGetterClass) {
        for (FieldGetter fg : getters) {
            if (fg.getClass() != fieldGetterClass) continue;
            return true;
        }
        return false;
    }
}

