/*
 * Decompiled with CFR 0.152.
 */
package org.noear.luffy.executor.s.python;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.script.Bindings;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.noear.luffy.executor.IJtExecutor;
import org.noear.luffy.executor.s.python.__JTEAPI_CLZ;
import org.noear.luffy.model.AFileModel;
import org.noear.luffy.utils.Datetime;
import org.noear.luffy.utils.ThreadData;
import org.noear.luffy.utils.Timecount;
import org.noear.luffy.utils.Timespan;
import org.noear.snack.ONode;
import org.noear.solon.Solon;
import org.noear.solon.core.handle.Context;

public class PythonJtExecutor
implements IJtExecutor {
    private static final ThreadData<StringBuilder> _tlBuilder = new ThreadData(() -> new StringBuilder(5120));
    private static final String _lock = "";
    private static PythonJtExecutor _g;
    private final ScriptEngine _eng;
    private final Invocable _eng_call;
    private final Set<String> _loaded_names = Collections.synchronizedSet(new HashSet());
    private final Bindings _bindings;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PythonJtExecutor singleton() {
        if (_g != null) return _g;
        String string = _lock;
        synchronized (_lock) {
            if (_g != null) return _g;
            _g = new PythonJtExecutor();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _g;
        }
    }

    private PythonJtExecutor() {
        ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
        this._eng = scriptEngineManager.getEngineByName("python");
        this._eng_call = (Invocable)((Object)this._eng);
        this._bindings = this._eng.getBindings(100);
        Solon.global().shared().forEach((k, v) -> this.sharedSet((String)k, v));
        Solon.global().onSharedAdd((k, v) -> this.sharedSet((String)k, v));
        this.sharedSet("__JTEAPI", new __JTEAPI_CLZ());
        this.sharedSet("Context", Context.class);
        this.sharedSet("ONode", ONode.class);
        this.sharedSet("Datetime", Datetime.class);
        this.sharedSet("Timecount", Timecount.class);
        this.sharedSet("Timespan", Timespan.class);
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("__global = {'lib':{},'lib_new':{}}\n\n");
            sb.append("def modelAndView(tml,mod):\n    return __JTEAPI.modelAndView(tml,mod)\n\n");
            sb.append("def requireX(path):\n    if path.startswith('$'):\n        path = path[1:]\n        __JTEAPI.require(path)\n        return __global['lib_new'][path]()\n    else:\n        __JTEAPI.require(path)\n        return __global['lib'][path]\n\n");
            this._eng.eval(sb.toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void sharedSet(String name, Object val) {
        this._eng.put(name, val);
    }

    public String language() {
        return "python";
    }

    public boolean isLoaded(String name2) {
        return this._loaded_names.contains(name2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean preLoad(String name2, AFileModel file) throws Exception {
        if (!this.isLoaded(name2)) {
            String string = name2.intern();
            synchronized (string) {
                if (!this.isLoaded(name2)) {
                    this._eng.eval(this.compilerAsFun(name2, file));
                    this._loaded_names.add(name2);
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void del(String name) {
        String name2 = name.replace(".", "_").replace("*", "_");
        String string = name2.intern();
        synchronized (string) {
            this._loaded_names.remove(name2);
            this._loaded_names.remove(name2 + "__lib");
        }
    }

    public void delAll() {
        this._loaded_names.clear();
    }

    public Object exec(String name, AFileModel file, Context ctx, Map<String, Object> model, boolean outString) throws Exception {
        String name2 = name.replace(".", "_").replace("*", "_");
        this.preLoad(name2, file);
        Object tmp = this._eng_call.invokeFunction("API_" + name2, ctx);
        if (tmp == null) {
            return null;
        }
        if (outString) {
            if (tmp instanceof Number || tmp instanceof String || tmp instanceof Boolean) {
                return tmp.toString();
            }
            return ONode.loadObj((Object)tmp).toJson();
        }
        return tmp;
    }

    public Object exec(String code, Map<String, Object> model) throws Exception {
        if (model != null) {
            Bindings bindings = this._eng.createBindings();
            bindings.putAll(this._bindings);
            bindings.putAll((Map<? extends String, ? extends Object>)model);
            return this._eng.eval(code, bindings);
        }
        return this._eng.eval(code);
    }

    public String compilerAsFun(String name, AFileModel file) {
        StringBuilder sb = (StringBuilder)_tlBuilder.get();
        sb.setLength(0);
        String[] lines = file.content.split("\n");
        if (name.endsWith("__lib")) {
            sb.append("class API_").append(name).append(":\n");
            int len = lines.length;
            for (int i = 0; i < len; ++i) {
                sb.append("    ").append(lines[i]).append("\n");
            }
            sb.append("\n\n");
            sb.append("__global['lib']['").append(file.path).append("']=").append("API_").append(name).append("()");
            sb.append("\n\n");
            sb.append("__global['lib_new']['").append(file.path).append("']=").append("API_").append(name);
        } else {
            sb.append("def API_").append(name).append("(ctx):\n");
            int len = lines.length;
            for (int i = 0; i < len; ++i) {
                sb.append("    ").append(lines[i]).append("\n");
            }
        }
        return sb.toString();
    }
}

