/*
 * Decompiled with CFR 0.152.
 */
package org.python.compiler;

import java.io.IOException;
import org.python.compiler.ClassConstants;
import org.python.compiler.Code;
import org.python.compiler.Constant;
import org.python.core.Py;
import org.python.core.PyInteger;
import org.python.objectweb.asm.Opcodes;
import org.python.util.CodegenUtils;

class PyIntegerConstant
extends Constant
implements ClassConstants,
Opcodes {
    final int value;

    PyIntegerConstant(int value) {
        this.value = value;
    }

    @Override
    void get(Code c) throws IOException {
        c.getstatic(this.module.classfile.name, this.name, CodegenUtils.ci(PyInteger.class));
    }

    @Override
    void put(Code c) throws IOException {
        this.module.classfile.addField(this.name, CodegenUtils.ci(PyInteger.class), access);
        c.iconst(this.value);
        c.invokestatic(CodegenUtils.p(Py.class), "newInteger", CodegenUtils.sig(PyInteger.class, Integer.TYPE));
        c.putstatic(this.module.classfile.name, this.name, CodegenUtils.ci(PyInteger.class));
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (o instanceof PyIntegerConstant) {
            return ((PyIntegerConstant)o).value == this.value;
        }
        return false;
    }
}

