/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import org.python.core.ArgParser;
import org.python.core.Py;
import org.python.core.PyBaseString;
import org.python.core.PyException;
import org.python.core.PyInteger;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyStringMap;
import org.python.core.PyTuple;
import org.python.core.PyUnicode;
import org.python.core.StringSubsequenceIterator;
import org.python.core.exceptions;
import org.python.core.imp;
import org.python.core.util.StringUtil;

public class codecs {
    public static final String BACKSLASHREPLACE = "backslashreplace";
    public static final String IGNORE = "ignore";
    public static final String REPLACE = "replace";
    public static final String XMLCHARREFREPLACE = "xmlcharrefreplace";
    private static char Py_UNICODE_REPLACEMENT_CHARACTER = (char)65533;
    private static PyList searchPath;
    private static PyStringMap searchCache;
    private static PyStringMap errorHandlers;
    private static final Object INIT_LOCK;
    private static String default_encoding;
    private static boolean import_encodings_called;
    static char[] hexdigits;
    private static final byte[] utf7_category;
    private static final String B64_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
    private static final byte[] BASE64_VALUE;
    private static byte[] utf8_code_length;
    private static char[] hexdigit;

    public static String getDefaultEncoding() {
        return default_encoding;
    }

    public static void setDefaultEncoding(String encoding) {
        codecs.lookup(encoding);
        default_encoding = encoding;
    }

    public static PyObject lookup_error(String handlerName) {
        PyObject handler;
        codecs.registry_init();
        if (handlerName == null) {
            handlerName = "strict";
        }
        if ((handler = errorHandlers.__finditem__(handlerName.intern())) == null) {
            throw new PyException(Py.LookupError, "unknown error handler name '" + handlerName + "'");
        }
        return handler;
    }

    public static void register_error(String name, PyObject error) {
        codecs.registry_init();
        if (!error.isCallable()) {
            throw Py.TypeError("argument must be callable");
        }
        errorHandlers.__setitem__(name.intern(), error);
    }

    public static void register(PyObject search_function) {
        codecs.registry_init();
        if (!search_function.isCallable()) {
            throw Py.TypeError("argument must be callable");
        }
        searchPath.append(search_function);
    }

    public static PyTuple lookup(String encoding) {
        codecs.registry_init();
        PyString v = new PyString(codecs.normalizestring(encoding));
        PyObject cached = searchCache.__finditem__(v);
        if (cached != null) {
            return (PyTuple)cached;
        }
        if (searchPath.__len__() == 0) {
            throw new PyException(Py.LookupError, "no codec search functions registered: can't find encoding '" + encoding + "'");
        }
        for (PyObject func : searchPath.asIterable()) {
            PyObject created = func.__call__(v);
            if (created == Py.None) continue;
            if (!(created instanceof PyTuple) || created.__len__() != 4) {
                throw Py.TypeError("codec search functions must return 4-tuples");
            }
            searchCache.__setitem__(v, created);
            return (PyTuple)created;
        }
        throw new PyException(Py.LookupError, "unknown encoding '" + encoding + "'");
    }

    private static String normalizestring(String string) {
        return string.toLowerCase().replace(' ', '-');
    }

    private static void import_encodings() {
        block3: {
            if (!import_encodings_called) {
                import_encodings_called = true;
                try {
                    imp.load("encodings");
                }
                catch (PyException exc) {
                    if (exc.type == Py.ImportError) break block3;
                    throw exc;
                }
            }
        }
    }

    public static PyObject decode(PyString v, String encoding, String errors) {
        PyObject decoder;
        encoding = encoding == null ? codecs.getDefaultEncoding() : codecs.normalizestring(encoding);
        if (errors != null) {
            errors = errors.intern();
        }
        if (encoding.equals("ascii")) {
            return codecs.wrapDecodeResult(codecs.PyUnicode_DecodeASCII(v.toString(), v.__len__(), errors));
        }
        try {
            decoder = codecs.lookup(encoding).__getitem__(1);
        }
        catch (PyException ex) {
            if (ex.match(Py.LookupError)) {
                if (encoding.equals("utf-8")) {
                    return codecs.wrapDecodeResult(codecs.PyUnicode_DecodeUTF8(v.toString(), errors));
                }
                if (encoding.equals("utf-7")) {
                    return codecs.wrapDecodeResult(codecs.PyUnicode_DecodeUTF7(v.toString(), errors));
                }
                if (encoding.equals("latin-1")) {
                    return codecs.wrapDecodeResult(codecs.PyUnicode_DecodeLatin1(v.toString(), v.__len__(), errors));
                }
            }
            throw ex;
        }
        PyObject result = errors != null ? decoder.__call__(v, (PyObject)new PyString(errors)) : decoder.__call__(v);
        if (!(result instanceof PyTuple) || result.__len__() != 2) {
            throw Py.TypeError("decoder must return a tuple (object,integer)");
        }
        return result.__getitem__(0);
    }

    private static PyUnicode wrapDecodeResult(String result) {
        return new PyUnicode(result, true);
    }

    public static String encode(PyString v, String encoding, String errors) {
        PyObject encoder;
        encoding = encoding == null ? codecs.getDefaultEncoding() : codecs.normalizestring(encoding);
        if (errors != null) {
            errors = errors.intern();
        }
        if (encoding.equals("latin-1")) {
            return codecs.PyUnicode_EncodeLatin1(v.toString(), v.__len__(), errors);
        }
        if (encoding.equals("ascii")) {
            return codecs.PyUnicode_EncodeASCII(v.toString(), v.__len__(), errors);
        }
        try {
            encoder = codecs.lookup(encoding).__getitem__(0);
        }
        catch (PyException ex) {
            if (ex.match(Py.LookupError)) {
                if (encoding.equals("utf-8")) {
                    return codecs.PyUnicode_EncodeUTF8(v.toString(), errors);
                }
                if (encoding.equals("utf-7")) {
                    return codecs.PyUnicode_EncodeUTF7(v.toString(), false, false, errors);
                }
            }
            throw ex;
        }
        PyObject result = errors != null ? encoder.__call__(v, (PyObject)new PyString(errors)) : encoder.__call__(v);
        if (!(result instanceof PyTuple) || result.__len__() != 2) {
            throw Py.TypeError("encoder must return a tuple (object,integer)");
        }
        PyObject encoded = result.__getitem__(0);
        if (encoded instanceof PyString) {
            return encoded.toString();
        }
        throw Py.TypeError("encoder did not return a string/unicode object (type=" + encoded.getType().fastGetName() + ")");
    }

    public static PyObject strict_errors(PyObject[] args, String[] kws) {
        ArgParser ap = new ArgParser("strict_errors", args, kws, "exc");
        PyObject exc = ap.getPyObject(0);
        if (Py.isInstance(exc, Py.UnicodeDecodeError)) {
            throw new PyException(Py.UnicodeDecodeError, exc);
        }
        if (Py.isInstance(exc, Py.UnicodeEncodeError)) {
            throw new PyException(Py.UnicodeEncodeError, exc);
        }
        if (Py.isInstance(exc, Py.UnicodeTranslateError)) {
            throw new PyException(Py.UnicodeTranslateError, exc);
        }
        throw codecs.wrong_exception_type(exc);
    }

    public static PyObject ignore_errors(PyObject[] args, String[] kws) {
        ArgParser ap = new ArgParser("ignore_errors", args, kws, "exc");
        PyObject exc = ap.getPyObject(0);
        if (!codecs.isUnicodeError(exc)) {
            throw codecs.wrong_exception_type(exc);
        }
        PyObject end = exc.__getattr__("end");
        return new PyTuple(Py.EmptyUnicode, end);
    }

    private static boolean isUnicodeError(PyObject exc) {
        return Py.isInstance(exc, Py.UnicodeDecodeError) || Py.isInstance(exc, Py.UnicodeEncodeError) || Py.isInstance(exc, Py.UnicodeTranslateError);
    }

    public static PyObject replace_errors(PyObject[] args, String[] kws) {
        ArgParser ap = new ArgParser("replace_errors", args, kws, "exc");
        PyObject exc = ap.getPyObject(0);
        if (Py.isInstance(exc, Py.UnicodeEncodeError)) {
            int end = exceptions.getEnd(exc, true);
            return new PyTuple(new PyUnicode("?"), Py.newInteger(end));
        }
        if (Py.isInstance(exc, Py.UnicodeDecodeError)) {
            int end = exceptions.getEnd(exc, false);
            return new PyTuple(new PyUnicode(Py_UNICODE_REPLACEMENT_CHARACTER), Py.newInteger(end));
        }
        if (Py.isInstance(exc, Py.UnicodeTranslateError)) {
            int end = exceptions.getEnd(exc, true);
            return new PyTuple(new PyUnicode(Py_UNICODE_REPLACEMENT_CHARACTER), Py.newInteger(end));
        }
        throw codecs.wrong_exception_type(exc);
    }

    public static PyObject xmlcharrefreplace_errors(PyObject[] args, String[] kws) {
        ArgParser ap = new ArgParser("xmlcharrefreplace_errors", args, kws, "exc");
        PyObject exc = ap.getPyObject(0);
        if (!Py.isInstance(exc, Py.UnicodeEncodeError)) {
            throw codecs.wrong_exception_type(exc);
        }
        int start = ((PyInteger)exc.__getattr__("start")).getValue();
        int end = ((PyInteger)exc.__getattr__("end")).getValue();
        String object = exc.__getattr__("object").toString();
        StringBuilder replacement = new StringBuilder();
        codecs.xmlcharrefreplace_internal(start, end, object, replacement);
        return new PyTuple(Py.java2py(replacement.toString()), exc.__getattr__("end"));
    }

    public static StringBuilder xmlcharrefreplace(int start, int end, String toReplace) {
        StringBuilder replacement = new StringBuilder();
        codecs.xmlcharrefreplace_internal(start, end, toReplace, replacement);
        return replacement;
    }

    private static void xmlcharrefreplace_internal(int start, int end, String object, StringBuilder replacement) {
        for (int i = start; i < end; ++i) {
            int base;
            int digits;
            replacement.append("&#");
            char cur = object.charAt(i);
            if (cur < '\n') {
                digits = 1;
                base = 1;
            } else if (cur < 'd') {
                digits = 2;
                base = 10;
            } else if (cur < '\u03e8') {
                digits = 3;
                base = 100;
            } else if (cur < '\u2710') {
                digits = 4;
                base = 1000;
            } else if (cur < '\u186a0') {
                digits = 5;
                base = 10000;
            } else if (cur < '\uf4240') {
                digits = 6;
                base = 100000;
            } else {
                digits = 7;
                base = 1000000;
            }
            while (digits-- > 0) {
                replacement.append((char)(48 + cur / base));
                cur = (char)(cur % base);
                base /= 10;
            }
            replacement.append(';');
        }
    }

    private static PyException wrong_exception_type(PyObject exc) {
        PyObject excClass = exc.__getattr__("__class__");
        PyObject className = excClass.__getattr__("__name__");
        return new PyException(Py.TypeError, "Don't know how to handle " + className + " in error callback");
    }

    public static PyObject backslashreplace_errors(PyObject[] args, String[] kws) {
        ArgParser ap = new ArgParser("backslashreplace_errors", args, kws, "exc");
        PyObject exc = ap.getPyObject(0);
        if (!Py.isInstance(exc, Py.UnicodeEncodeError)) {
            throw codecs.wrong_exception_type(exc);
        }
        int start = ((PyInteger)exc.__getattr__("start")).getValue();
        int end = ((PyInteger)exc.__getattr__("end")).getValue();
        String object = exc.__getattr__("object").toString();
        StringBuilder replacement = new StringBuilder();
        codecs.backslashreplace_internal(start, end, object, replacement);
        return new PyTuple(Py.java2py(replacement.toString()), exc.__getattr__("end"));
    }

    public static StringBuilder backslashreplace(int start, int end, String toReplace) {
        StringBuilder replacement = new StringBuilder();
        codecs.backslashreplace_internal(start, end, toReplace, replacement);
        return replacement;
    }

    private static void backslashreplace_internal(int start, int end, String object, StringBuilder replacement) {
        StringSubsequenceIterator iter = new StringSubsequenceIterator(object, start, end, 1);
        while (iter.hasNext()) {
            int c = (Integer)iter.next();
            replacement.append('\\');
            if (c >= 65536) {
                replacement.append('U');
                replacement.append(hexdigits[c >> 28 & 0xF]);
                replacement.append(hexdigits[c >> 24 & 0xF]);
                replacement.append(hexdigits[c >> 20 & 0xF]);
                replacement.append(hexdigits[c >> 16 & 0xF]);
                replacement.append(hexdigits[c >> 12 & 0xF]);
                replacement.append(hexdigits[c >> 8 & 0xF]);
            } else if (c >= 256) {
                replacement.append('u');
                replacement.append(hexdigits[c >> 12 & 0xF]);
                replacement.append(hexdigits[c >> 8 & 0xF]);
            } else {
                replacement.append('x');
            }
            replacement.append(hexdigits[c >> 4 & 0xF]);
            replacement.append(hexdigits[c & 0xF]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void registry_init() {
        Object object = INIT_LOCK;
        synchronized (object) {
            String[] builtinErrorHandlers;
            if (searchPath != null) {
                return;
            }
            searchPath = new PyList();
            searchCache = new PyStringMap();
            errorHandlers = new PyStringMap();
            for (String builtinErrorHandler : builtinErrorHandlers = new String[]{"strict", IGNORE, REPLACE, XMLCHARREFREPLACE, BACKSLASHREPLACE}) {
                codecs.register_error(builtinErrorHandler, Py.newJavaFunc(codecs.class, builtinErrorHandler + "_errors"));
            }
            codecs.import_encodings();
        }
    }

    private static boolean ENCODE_DIRECT(int c, boolean directO, boolean directWS) {
        if (c >= 128 || c < 0) {
            return false;
        }
        switch (utf7_category[c]) {
            case 0: {
                return true;
            }
            case 1: {
                return directWS;
            }
            case 2: {
                return directO;
            }
        }
        return false;
    }

    private static char TO_BASE64(int n) {
        return B64_CHARS.charAt(n & 0x3F);
    }

    private static int FROM_BASE64(int c) {
        return c >= 128 ? -1 : BASE64_VALUE[c];
    }

    public static String PyUnicode_DecodeUTF7Stateful(String bytes, String errors, int[] consumed) {
        boolean s;
        int unicode;
        boolean bl = false;
        long inBase64 = 0L;
        int n = 0;
        int base64bits = 0;
        int startInBytes = 0;
        int syncInBytes = 0;
        int startInUnicode = bytes.length();
        StringBuilder size = new StringBuilder(startInUnicode);
        for (unicode = 0; unicode < startInUnicode; ++unicode) {
            char b = bytes.charAt(unicode);
            if (b >= '\u0080') {
                unicode = codecs.insertReplacementAndGetResume(size, errors, "utf-7", bytes, unicode, unicode + 1, "unexpected special character") - 1;
                continue;
            }
            if (s) {
                UTF7Error error;
                int sixBits;
                if (n == 0) {
                    startInBytes = unicode;
                }
                if ((sixBits = codecs.FROM_BASE64(b)) >= 0) {
                    inBase64 = inBase64 << 6 | (long)sixBits;
                    if ((n += 6) < 32 || (n = codecs.emitCodePoints(size, inBase64, n)) < 32) continue;
                    error = codecs.emitCodePointsDiagnosis(inBase64, n);
                    unicode = codecs.insertReplacementAndGetResume(size, errors, "utf-7", bytes, startInBytes, unicode + 1, error.msg) - 1;
                    n -= 16;
                    continue;
                }
                s = false;
                if (n > 0) {
                    error = codecs.emitCodePointsDiagnosis(inBase64, n = codecs.emitCodePoints(size, inBase64, n));
                    if (error != UTF7Error.NONE) {
                        unicode = codecs.insertReplacementAndGetResume(size, errors, "utf-7", bytes, unicode, unicode + 1, error.msg) - 1;
                    }
                    n = 0;
                }
                if (b == '-') {
                    if (unicode != base64bits + 1) continue;
                    size.append('+');
                    continue;
                }
                size.appendCodePoint(b);
                continue;
            }
            if (b == '+') {
                base64bits = unicode;
                syncInBytes = size.length();
                n = 0;
                s = true;
                continue;
            }
            size.appendCodePoint(b);
        }
        if (s) {
            unicode = base64bits;
            size.setLength(syncInBytes);
        }
        if (consumed != null) {
            consumed[0] = unicode;
        } else if (unicode < startInUnicode) {
            unicode = codecs.insertReplacementAndGetResume(size, errors, "utf-7", bytes, base64bits, startInUnicode, "unterminated shift sequence");
        }
        return size.toString();
    }

    public static String PyUnicode_DecodeUTF7(String bytes, String errors) {
        return codecs.PyUnicode_DecodeUTF7Stateful(bytes, errors, null);
    }

    private static int emitCodePoints(StringBuilder v, long buffer, int n) {
        while (n >= 16) {
            boolean unitIsSurrogate;
            int unit = (int)(buffer >>> n - 16);
            boolean bl = unitIsSurrogate = (unit & 0xF800) == 55296;
            if (!unitIsSurrogate) {
                v.append((char)unit);
                n -= 16;
                continue;
            }
            if (n >= 32) {
                if ((unit & 0x400) == 0) {
                    int unit2 = (int)(buffer >>> n - 32);
                    if ((unit2 & 0xFC00) == 56320) {
                        v.appendCodePoint(65536 + ((unit & 0x3FF) << 10) + (unit2 & 0x3FF));
                        n -= 32;
                        continue;
                    }
                    return n;
                }
                return n;
            }
            return n;
        }
        return n;
    }

    private static UTF7Error emitCodePointsDiagnosis(long buffer, int n) {
        if (n >= 16) {
            boolean unitIsSurrogate;
            int unit = (int)(buffer >>> n - 16);
            boolean bl = unitIsSurrogate = (unit & 0xF800) == 55296;
            if (!unitIsSurrogate) {
                return UTF7Error.NONE;
            }
            if (n >= 32) {
                if ((unit & 0x400) == 0) {
                    int unit2 = (int)(buffer >>> n - 32) & 0xFFFF;
                    if ((unit2 & 0xFC00) == 56320) {
                        return UTF7Error.NONE;
                    }
                    return UTF7Error.MISSING;
                }
                return UTF7Error.TRAIL;
            }
            if ((unit & 0x400) == 0) {
                return UTF7Error.TRUNCATED;
            }
            return UTF7Error.TRAIL;
        }
        if (n >= 6) {
            return UTF7Error.PARTIAL;
        }
        int validBits = (1 << n) - 1;
        int padding = (int)buffer & validBits;
        if (padding != 0) {
            return UTF7Error.PADDING;
        }
        return UTF7Error.NONE;
    }

    public static String PyUnicode_EncodeUTF7(String unicode, boolean base64SetO, boolean base64WhiteSpace, String errors) {
        boolean inBase64 = false;
        int base64bits = 0;
        long base64buffer = 0L;
        int size = unicode.length();
        StringBuilder v = new StringBuilder(size + size / 8 + 10);
        for (int i = 0; i < size; ++i) {
            int ch = unicode.charAt(i);
            if (inBase64) {
                if (codecs.ENCODE_DIRECT(ch, !base64SetO, !base64WhiteSpace)) {
                    codecs.emitBase64Padded(v, base64buffer, base64bits);
                    inBase64 = false;
                    if (codecs.FROM_BASE64(ch) != -1) {
                        v.append('-');
                    }
                }
            } else if (ch == 43) {
                v.append('+');
                ch = 45;
            } else if (!codecs.ENCODE_DIRECT(ch, !base64SetO, !base64WhiteSpace)) {
                v.append('+');
                inBase64 = true;
                base64bits = 0;
            }
            if (!inBase64) {
                v.append((char)ch);
                continue;
            }
            if (base64bits > 48) {
                base64bits = codecs.emitBase64(v, base64buffer, base64bits);
            }
            base64bits += 16;
            base64buffer = (base64buffer << 16) + (long)ch;
        }
        if (inBase64) {
            codecs.emitBase64Padded(v, base64buffer, base64bits);
            v.append('-');
        }
        return v.toString();
    }

    private static int emitBase64(StringBuilder v, long buffer, int n) {
        while (n >= 6) {
            long sixBits = buffer >>> (n -= 6);
            char b64byte = codecs.TO_BASE64((int)sixBits);
            v.append(b64byte);
        }
        return n;
    }

    private static void emitBase64Padded(StringBuilder v, long buffer, int n) {
        if (n > 0) {
            int npad = 5 - (n + 5) % 6;
            codecs.emitBase64(v, buffer << npad, n + npad);
        }
    }

    public static String PyUnicode_DecodeUTF8(String str, String errors) {
        return codecs.PyUnicode_DecodeUTF8Stateful(str, errors, null);
    }

    public static String PyUnicode_DecodeUTF8Stateful(String str, String errors, int[] consumed) {
        int size = str.length();
        StringBuilder unicode = new StringBuilder(size);
        int i = 0;
        block7: while (i < size) {
            int ch = str.charAt(i);
            if (ch < 128) {
                unicode.append((char)ch);
                ++i;
                continue;
            }
            if (ch > 255) {
                i = codecs.insertReplacementAndGetResume(unicode, errors, "utf-8", str, i, i + 1, "ordinal not in range(255)");
                continue;
            }
            byte n = utf8_code_length[ch];
            if (i + n > size) {
                if (consumed != null) break;
                i = codecs.insertReplacementAndGetResume(unicode, errors, "utf-8", str, i, i + 1, "unexpected end of data");
                continue;
            }
            switch (n) {
                case 0: {
                    i = codecs.insertReplacementAndGetResume(unicode, errors, "utf-8", str, i, i + 1, "unexpected code byte");
                    continue block7;
                }
                case 1: {
                    i = codecs.insertReplacementAndGetResume(unicode, errors, "utf-8", str, i, i + 1, "internal error");
                    continue block7;
                }
                case 2: {
                    char ch1 = str.charAt(i + 1);
                    if ((ch1 & 0xC0) != 128) {
                        i = codecs.insertReplacementAndGetResume(unicode, errors, "utf-8", str, i, i + 2, "invalid data");
                        continue block7;
                    }
                    if ((ch = ((ch & 0x1F) << 6) + (ch1 & 0x3F)) < 128) {
                        i = codecs.insertReplacementAndGetResume(unicode, errors, "utf-8", str, i, i + 2, "illegal encoding");
                        continue block7;
                    }
                    unicode.appendCodePoint(ch);
                    break;
                }
                case 3: {
                    char ch1 = str.charAt(i + 1);
                    char ch2 = str.charAt(i + 2);
                    if ((ch1 & 0xC0) != 128 || (ch2 & 0xC0) != 128) {
                        i = codecs.insertReplacementAndGetResume(unicode, errors, "utf-8", str, i, i + 3, "invalid data");
                        continue block7;
                    }
                    if ((ch = ((ch & 0xF) << 12) + ((ch1 & 0x3F) << 6) + (ch2 & 0x3F)) < 2048 || ch >= 55296 && ch < 57344) {
                        i = codecs.insertReplacementAndGetResume(unicode, errors, "utf-8", str, i, i + 3, "illegal encoding");
                        continue block7;
                    }
                    unicode.appendCodePoint(ch);
                    break;
                }
                case 4: {
                    char ch1 = str.charAt(i + 1);
                    char ch2 = str.charAt(i + 2);
                    char ch3 = str.charAt(i + 3);
                    if ((ch1 & 0xC0) != 128 || (ch2 & 0xC0) != 128 || (ch3 & 0xC0) != 128) {
                        i = codecs.insertReplacementAndGetResume(unicode, errors, "utf-8", str, i, i + 4, "invalid data");
                        continue block7;
                    }
                    if ((ch = ((ch & 7) << 18) + ((ch1 & 0x3F) << 12) + ((ch2 & 0x3F) << 6) + (ch3 & 0x3F)) < 65536 || ch > 0x10FFFF) {
                        i = codecs.insertReplacementAndGetResume(unicode, errors, "utf-8", str, i, i + 4, "illegal encoding");
                        continue block7;
                    }
                    unicode.appendCodePoint(ch);
                    break;
                }
                default: {
                    i = codecs.insertReplacementAndGetResume(unicode, errors, "utf-8", str, i, i + n, "unsupported Unicode code range");
                    continue block7;
                }
            }
            i += n;
        }
        if (consumed != null) {
            consumed[0] = i;
        }
        return unicode.toString();
    }

    public static String PyUnicode_EncodeUTF8(String str, String errors) {
        return StringUtil.fromBytes(Charset.forName("UTF-8").encode(str));
    }

    public static String PyUnicode_DecodeASCII(String str, int size, String errors) {
        return codecs.PyUnicode_DecodeIntLimited(str, size, errors, "ascii", 128);
    }

    public static String PyUnicode_DecodeLatin1(String str, int size, String errors) {
        return codecs.PyUnicode_DecodeIntLimited(str, size, errors, "latin-1", 256);
    }

    private static String PyUnicode_DecodeIntLimited(String str, int size, String errors, String encoding, int limit) {
        StringBuilder v = new StringBuilder(size);
        String reason = "ordinal not in range(" + limit + ")";
        for (int i = 0; i < size; ++i) {
            char ch = str.charAt(i);
            if (ch < limit) {
                v.append(ch);
                continue;
            }
            i = codecs.insertReplacementAndGetResume(v, errors, encoding, str, i, i + 1, reason) - 1;
        }
        return v.toString();
    }

    public static String PyUnicode_EncodeASCII(String str, int size, String errors) {
        return codecs.PyUnicode_EncodeIntLimited(str, size, errors, "ascii", 128);
    }

    public static String PyUnicode_EncodeLatin1(String str, int size, String errors) {
        return codecs.PyUnicode_EncodeIntLimited(str, size, errors, "latin-1", 256);
    }

    private static String PyUnicode_EncodeIntLimited(String str, int size, String errors, String encoding, int limit) {
        String reason = "ordinal not in range(" + limit + ")";
        StringBuilder v = new StringBuilder(size);
        for (int i = 0; i < size; ++i) {
            char ch = str.charAt(i);
            if (ch >= limit) {
                int nextGood;
                for (nextGood = i + 1; nextGood < size && str.charAt(nextGood) >= limit; ++nextGood) {
                }
                if (errors != null) {
                    if (errors.equals(IGNORE)) {
                        i = nextGood - 1;
                        continue;
                    }
                    if (errors.equals(REPLACE)) {
                        for (int j = i; j < nextGood; ++j) {
                            v.append('?');
                        }
                        i = nextGood - 1;
                        continue;
                    }
                    if (errors.equals(XMLCHARREFREPLACE)) {
                        v.append((CharSequence)codecs.xmlcharrefreplace(i, nextGood, str));
                        i = nextGood - 1;
                        continue;
                    }
                    if (errors.equals(BACKSLASHREPLACE)) {
                        v.append((CharSequence)codecs.backslashreplace(i, nextGood, str));
                        i = nextGood - 1;
                        continue;
                    }
                }
                PyObject replacement = codecs.encoding_error(errors, encoding, str, i, nextGood, reason);
                String replStr = replacement.__getitem__(0).toString();
                for (int j = 0; j < replStr.length(); ++j) {
                    if (replStr.charAt(j) < limit) continue;
                    throw Py.UnicodeEncodeError(encoding, str, i + j, i + j + 1, reason);
                }
                v.append(replStr);
                i = codecs.calcNewPosition(size, replacement) - 1;
                continue;
            }
            v.append(ch);
        }
        return v.toString();
    }

    public static String PyUnicode_EncodeRawUnicodeEscape(String str, String errors, boolean modifed) {
        StringBuilder v = new StringBuilder(str.length());
        Iterator<Integer> iter = new PyUnicode(str).newSubsequenceIterator();
        while (iter.hasNext()) {
            int codePoint = iter.next();
            if (codePoint >= 65536) {
                v.append("\\U");
                v.append(hexdigit[codePoint >> 28 & 0xF]);
                v.append(hexdigit[codePoint >> 24 & 0xF]);
                v.append(hexdigit[codePoint >> 20 & 0xF]);
                v.append(hexdigit[codePoint >> 16 & 0xF]);
                v.append(hexdigit[codePoint >> 12 & 0xF]);
                v.append(hexdigit[codePoint >> 8 & 0xF]);
                v.append(hexdigit[codePoint >> 4 & 0xF]);
                v.append(hexdigit[codePoint & 0xF]);
                continue;
            }
            if (codePoint >= 256 || modifed && (codePoint == 92 || codePoint == 10)) {
                v.append("\\u");
                v.append(hexdigit[codePoint >> 12 & 0xF]);
                v.append(hexdigit[codePoint >> 8 & 0xF]);
                v.append(hexdigit[codePoint >> 4 & 0xF]);
                v.append(hexdigit[codePoint & 0xF]);
                continue;
            }
            v.append((char)codePoint);
        }
        return v.toString();
    }

    public static String PyUnicode_DecodeRawUnicodeEscape(String str, String errors) {
        int size = str.length();
        StringBuilder v = new StringBuilder(size);
        int i = 0;
        while (i < size) {
            char ch = str.charAt(i);
            if (ch != '\\') {
                v.append(ch);
                ++i;
                continue;
            }
            int bs = i;
            while (i < size && (ch = str.charAt(i)) == '\\') {
                v.append(ch);
                ++i;
            }
            if ((i - bs & 1) == 0 || i >= size || ch != 'u' && ch != 'U') continue;
            v.setLength(v.length() - 1);
            int count2 = ch == 'u' ? 4 : 8;
            ++i;
            int codePoint = 0;
            int asDigit = -1;
            for (int j = 0; j < count2; ++j) {
                if (i == size) {
                    asDigit = -1;
                    break;
                }
                ch = str.charAt(i);
                asDigit = Character.digit(ch, 16);
                if (asDigit == -1) break;
                codePoint = (codePoint << 4 & 0xFFFFFFF0) + asDigit;
                ++i;
            }
            if (asDigit == -1) {
                i = codecs.insertReplacementAndGetResume(v, errors, "rawunicodeescape", str, bs, i, "truncated \\uXXXX");
                continue;
            }
            v.appendCodePoint(codePoint);
        }
        return v.toString();
    }

    public static String PyUnicode_EncodePunycode(PyUnicode input, String errors) {
        int buffer2;
        int n = 128;
        int delta = 0;
        int n2 = 72;
        int n3 = 0;
        StringBuilder bias = new StringBuilder();
        for (int buffer2 : input) {
            if (!Punycode.isBasic(buffer2)) continue;
            bias.appendCodePoint(buffer2);
            ++n3;
        }
        if (n3 > 0) {
            bias.appendCodePoint(45);
        }
        int b = n3;
        buffer2 = input.getCodePointCount();
        while (b < buffer2) {
            int h = Integer.MAX_VALUE;
            int size = 0;
            int m = 0;
            for (int codePointIndex : input) {
                if (codePointIndex > n && codePointIndex < h) {
                    h = codePointIndex;
                    m = size;
                }
                ++size;
            }
            long iter = delta + (h - n) * (b + 1);
            if (iter > Integer.MAX_VALUE) {
                throw Py.UnicodeEncodeError("punycode", input.getString(), m, m + 1, "overflow");
            }
            delta = (int)iter;
            n = h;
            size = 0;
            for (int codePointIndex : input) {
                if (codePointIndex < n) {
                    iter = delta + 1;
                    if (iter > Integer.MAX_VALUE) {
                        throw Py.UnicodeEncodeError("punycode", input.getString(), size, size + 1, "overflow");
                    }
                    delta = (int)iter;
                }
                if (codePointIndex == n) {
                    int guard_delta;
                    int q = delta;
                    int k = 36;
                    while (true) {
                        int t;
                        int n4 = k <= guard_delta ? 1 : (t = k >= guard_delta + 26 ? 26 : k - guard_delta);
                        if (q < t) break;
                        bias.appendCodePoint(t + (q - t) % (36 - t));
                        q = (q - t) / (36 - t);
                        k += 36;
                    }
                    bias.appendCodePoint(q);
                    guard_delta = Punycode.adapt(delta, b + 1, b == n3);
                    delta = 0;
                    ++b;
                }
                ++size;
            }
            ++delta;
            ++n;
        }
        return bias.toString();
    }

    public static PyUnicode PyUnicode_DecodePunycode(String input, String errors) {
        int j;
        int input_size = input.length();
        int output_size = 0;
        ArrayList<Integer> ucs4 = new ArrayList<Integer>(input_size);
        for (j = 0; j < input_size; ++j) {
            char c = input.charAt(j);
            if (!Punycode.isBasic(c)) {
                throw Py.UnicodeDecodeError("punycode", input, j, j + 1, "not basic");
            }
            if (c == '-') break;
            ucs4.add(Integer.valueOf(c));
            ++output_size;
        }
        int n = 128;
        int i = 0;
        int bias = 72;
        while (j < input_size) {
            int old_i = i;
            int w = 1;
            int k = 36;
            while (true) {
                int t;
                char c;
                int digit;
                long guard_i;
                if ((guard_i = (long)(i + (digit = (c = input.charAt(j++)) - 48) * w)) > Integer.MAX_VALUE) {
                    throw Py.UnicodeDecodeError("punycode", input, j, j + 1, "overflow");
                }
                i = (int)guard_i;
                int n2 = k <= bias ? 1 : (t = k >= bias + 26 ? 26 : k - bias);
                if (digit < t) break;
                long guard_w = w * 36 - t;
                if (guard_w > Integer.MAX_VALUE) {
                    throw Py.UnicodeDecodeError("punycode", input, j, j + 1, "overflow");
                }
                k += 36;
            }
            bias = Punycode.adapt(i - old_i, output_size + 1, old_i == 0);
            n += i / (output_size + 1);
            ucs4.add(i %= output_size + 1, n);
        }
        return new PyUnicode(ucs4);
    }

    public static String PyUnicode_EncodeIDNA(PyUnicode input, String errors) {
        throw new UnsupportedOperationException();
    }

    public static PyUnicode PyUnicode_DecodeIDNA(String input, String errors) {
        throw new UnsupportedOperationException();
    }

    public static PyObject encoding_error(String errors, String encoding, String toEncode, int start, int end, String reason) {
        PyObject errorHandler = codecs.lookup_error(errors);
        PyException exc = Py.UnicodeEncodeError(encoding, toEncode, start, end, reason);
        exc.normalize();
        PyObject replacement = errorHandler.__call__(new PyObject[]{exc.value});
        codecs.checkErrorHandlerReturn(errors, replacement);
        return replacement;
    }

    public static int insertReplacementAndGetResume(StringBuilder partialDecode, String errors, String encoding, String toDecode, int start, int end, String reason) {
        if (errors != null) {
            if (errors.equals(IGNORE)) {
                return end;
            }
            if (errors.equals(REPLACE)) {
                partialDecode.appendCodePoint(Py_UNICODE_REPLACEMENT_CHARACTER);
                return end;
            }
        }
        PyObject replacementSpec = codecs.decoding_error(errors, encoding, toDecode, start, end, reason);
        partialDecode.append(replacementSpec.__getitem__(0).toString());
        return codecs.calcNewPosition(toDecode.length(), replacementSpec);
    }

    public static PyObject decoding_error(String errors, String encoding, String toDecode, int start, int end, String reason) {
        PyObject errorHandler = codecs.lookup_error(errors);
        PyException exc = Py.UnicodeDecodeError(encoding, toDecode, start, end, reason);
        exc.normalize();
        PyObject replacementSpec = errorHandler.__call__(new PyObject[]{exc.value});
        codecs.checkErrorHandlerReturn(errors, replacementSpec);
        return replacementSpec;
    }

    private static void checkErrorHandlerReturn(String errors, PyObject replacementSpec) {
        if (!(replacementSpec instanceof PyTuple && replacementSpec.__len__() == 2 && replacementSpec.__getitem__(0) instanceof PyBaseString && replacementSpec.__getitem__(1) instanceof PyInteger)) {
            throw new PyException(Py.TypeError, "error_handler " + errors + " must return a tuple of (replacement, new position)");
        }
    }

    public static int calcNewPosition(int size, PyObject errorTuple) {
        int newPosition = ((PyInteger)errorTuple.__getitem__(1)).getValue();
        if (newPosition < 0) {
            newPosition = size + newPosition;
        }
        if (newPosition > size || newPosition < 0) {
            throw Py.IndexError(newPosition + " out of bounds of encoded string");
        }
        return newPosition;
    }

    static {
        INIT_LOCK = new Object();
        default_encoding = "ascii";
        hexdigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        utf7_category = new byte[]{3, 3, 3, 3, 3, 3, 3, 3, 3, 2, 2, 3, 3, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 2, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 3, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 3, 3};
        BASE64_VALUE = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -2, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -1, -1, -1, -1, -1};
        utf8_code_length = new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 6, 6, 0, 0};
        hexdigit = "0123456789ABCDEF".toCharArray();
    }

    private static class Punycode {
        private static final int BASE = 36;
        private static final int TMIN = 1;
        private static final int TMAX = 26;
        private static final int SKEW = 38;
        private static final int DAMP = 700;
        private static final int INITIAL_BIAS = 72;
        private static final int INITIAL_N = 128;
        private static final int BASIC = 128;

        private Punycode() {
        }

        private static int adapt(int delta, int numpoints, boolean firsttime) {
            delta = firsttime ? delta / 700 : delta >> 1;
            delta += delta / numpoints;
            int k = 0;
            while (delta > 455) {
                delta /= 35;
                k += 36;
            }
            return k + 36 * delta / (delta + 38);
        }

        private static boolean isBasic(int codePoint) {
            return codePoint < 128;
        }
    }

    static enum UTF7Error {
        NONE("No error"),
        PADDING("non-zero padding bits in shift sequence"),
        PARTIAL("partial character in shift sequence"),
        TRUNCATED("second surrogate missing at end of shift sequence"),
        MISSING("second surrogate missing"),
        TRAIL("unexpected second surrogate");

        final String msg;

        private UTF7Error(String msg) {
            this.msg = msg;
        }
    }
}

