/*
 * Decompiled with CFR 0.152.
 */
package org.noear.luffy.queue.redis;

import java.util.Properties;
import org.noear.luffy.dso.CfgUtil;
import org.noear.luffy.dso.IJtQueue;
import org.noear.luffy.dso.JtBridge;
import org.noear.luffy.dso.LogLevel;
import org.noear.luffy.dso.LogUtil;
import org.noear.luffy.queue.redis.RedisX;
import org.noear.luffy.utils.ConfigUtils;

public class RedisJtQueue
implements IJtQueue {
    private RedisX _redisX;
    private String _name;

    public RedisJtQueue(String name, Properties prop) {
        this._name = name;
        this._redisX = new RedisX(prop);
    }

    public static void init(String cfg) throws Exception {
        Properties prop;
        if (cfg == null) {
            return;
        }
        String prop_str = cfg;
        if (cfg.startsWith("@")) {
            prop_str = CfgUtil.cfgGetValue((String)cfg.substring(1));
        }
        if ((prop = ConfigUtils.getProp((String)prop_str)) != null && prop.size() >= 5) {
            JtBridge.queueFactorySet(name -> new RedisJtQueue((String)name, prop));
        } else {
            LogUtil.log((String)"RedisJtQueue", (LogLevel)LogLevel.WARN, (String)"\u521d\u59cb\u5316\u5931\u8d25\uff0c\u53c2\u6570\u6709\u95ee\u9898", (String)prop_str);
        }
    }

    public String name() {
        return this._name;
    }

    public void add(String item) {
        if (item != null) {
            this._redisX.open0(rs -> rs.key(this.name()).listAdd(item));
        }
    }

    public void addAll(Iterable<String> items) {
        this._redisX.open0(rs -> {
            for (String item : items) {
                if (item == null) continue;
                rs.key(this.name()).listAdd(item);
            }
        });
    }

    public String peek() {
        return this._redisX.open1(rs -> rs.key(this.name()).listGet(-1));
    }

    public String poll() {
        return this._redisX.open1(rs -> rs.key(this.name()).listPop());
    }

    public void remove() {
        this._redisX.open0(rs -> rs.key(this.name()).listPop());
    }
}

