/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.mqtt.service;

import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudEventHandler;
import org.noear.solon.cloud.CloudProps;
import org.noear.solon.cloud.model.Event;
import org.noear.solon.cloud.service.CloudEventObserverManger;
import org.noear.solon.core.event.EventBus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MqttCallbackImp
implements MqttCallback {
    static Logger log = LoggerFactory.getLogger(MqttCallbackImp.class);
    final MqttClient client;
    final String eventChannelName;
    CloudEventObserverManger observerManger;

    public MqttCallbackImp(MqttClient client, CloudProps cloudProps) {
        this.client = client;
        this.eventChannelName = cloudProps.getEventChannel();
    }

    public void subscribe(CloudEventObserverManger observerManger) throws MqttException {
        this.observerManger = observerManger;
        String[] topicAry = observerManger.topicAll().toArray(new String[0]);
        int[] topicQos = new int[topicAry.length];
        int len = topicQos.length;
        for (int i = 0; i < len; ++i) {
            topicQos[i] = 1;
        }
        this.client.subscribe(topicAry, topicQos);
    }

    public void connectionLost(Throwable ex) {
        EventBus.push((Object)ex);
    }

    public void messageArrived(String topic, MqttMessage message) throws Exception {
        try {
            Event event = new Event(topic, new String(message.getPayload())).qos(message.getQos()).retained(message.isRetained()).channel(this.eventChannelName);
            CloudEventHandler handler = this.observerManger.getByTopic(topic);
            if (handler != null) {
                handler.handle(event);
            } else {
                log.warn("There is no observer for this event topic[{}]", (Object)event.topic());
            }
        }
        catch (Throwable ex) {
            ex = Utils.throwableUnwrap((Throwable)ex);
            EventBus.push((Object)ex);
            if (ex instanceof Exception) {
                throw (Exception)ex;
            }
            throw new RuntimeException(ex);
        }
    }

    public void deliveryComplete(IMqttDeliveryToken token) {
    }
}

