/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.mqtt.service;

import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.noear.solon.cloud.CloudEventHandler;
import org.noear.solon.cloud.CloudProps;
import org.noear.solon.cloud.extend.mqtt.service.MqttUtil;
import org.noear.solon.cloud.model.EventObserver;
import org.noear.solon.cloud.service.CloudEventObserverManger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttCallbackImpl
implements MqttCallback {
    static Logger log = LoggerFactory.getLogger(MqttCallbackImpl.class);
    final MqttClient client;
    final CloudEventObserverManger observerManger;
    final String eventChannelName;

    public MqttCallbackImpl(MqttClient client, CloudEventObserverManger observerManger, CloudProps cloudProps) {
        this.client = client;
        this.observerManger = observerManger;
        this.eventChannelName = cloudProps.getEventChannel();
    }

    public void connectionLost(Throwable e) {
        log.warn(e.getMessage(), e);
    }

    public void messageArrived(String topic, MqttMessage message) throws Exception {
        EventObserver eventHandler = this.observerManger.getByTopic(topic);
        MqttUtil.receive(log, this.eventChannelName, (CloudEventHandler)eventHandler, topic, message);
    }

    public void deliveryComplete(IMqttDeliveryToken token) {
    }
}

