/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.mqtt5.service;

import org.eclipse.paho.mqttv5.client.IMqttToken;
import org.eclipse.paho.mqttv5.client.MqttCallback;
import org.eclipse.paho.mqttv5.client.MqttClient;
import org.eclipse.paho.mqttv5.client.MqttDisconnectResponse;
import org.eclipse.paho.mqttv5.common.MqttException;
import org.eclipse.paho.mqttv5.common.MqttMessage;
import org.eclipse.paho.mqttv5.common.packet.MqttProperties;
import org.noear.solon.cloud.CloudEventHandler;
import org.noear.solon.cloud.CloudProps;
import org.noear.solon.cloud.extend.mqtt5.service.MqttUtil;
import org.noear.solon.cloud.model.EventObserver;
import org.noear.solon.cloud.service.CloudEventObserverManger;
import org.noear.solon.core.event.EventBus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttCallbackImpl
implements MqttCallback {
    static Logger log = LoggerFactory.getLogger(MqttCallbackImpl.class);
    final MqttClient client;
    final CloudEventObserverManger observerManger;
    final String eventChannelName;

    public MqttCallbackImpl(MqttClient client, CloudEventObserverManger observerManger, CloudProps cloudProps) {
        this.client = client;
        this.observerManger = observerManger;
        this.eventChannelName = cloudProps.getEventChannel();
    }

    public void disconnected(MqttDisconnectResponse disconnectResponse) {
    }

    public void mqttErrorOccurred(MqttException exception) {
        EventBus.publishTry((Object)exception);
    }

    public void messageArrived(String topic, MqttMessage message) throws Exception {
        EventObserver eventHandler = this.observerManger.getByTopic(topic);
        MqttUtil.receive(log, this.eventChannelName, (CloudEventHandler)eventHandler, topic, message);
    }

    public void deliveryComplete(IMqttToken token) {
    }

    public void connectComplete(boolean reconnect, String serverURI) {
    }

    public void authPacketArrived(int reasonCode, MqttProperties properties) {
    }
}

