/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.mqtt5.service;

import org.eclipse.paho.mqttv5.client.IMqttMessageListener;
import org.eclipse.paho.mqttv5.client.MqttClient;
import org.eclipse.paho.mqttv5.common.MqttException;
import org.eclipse.paho.mqttv5.common.MqttMessage;
import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudEventHandler;
import org.noear.solon.cloud.exception.CloudEventException;
import org.noear.solon.cloud.extend.mqtt5.service.MqttMessageListenerImpl;
import org.noear.solon.cloud.model.Event;
import org.noear.solon.cloud.model.EventObserver;
import org.noear.solon.cloud.service.CloudEventObserverManger;
import org.noear.solon.core.event.EventBus;
import org.slf4j.Logger;

public class MqttUtil {
    public static void receive(Logger log, String eventChannelName, CloudEventHandler eventHandler, String topic, MqttMessage message) throws Exception {
        try {
            Event event = new Event(topic, new String(message.getPayload())).qos(message.getQos()).retained(message.isRetained()).channel(eventChannelName);
            if (eventHandler != null) {
                if (!eventHandler.handle(event)) {
                    throw new CloudEventException("This event handling returns false: " + event.topic());
                }
            } else {
                log.warn("There is no observer for this event topic[{}]", (Object)event.topic());
            }
        }
        catch (Throwable ex) {
            ex = Utils.throwableUnwrap((Throwable)ex);
            EventBus.publishTry((Object)ex);
            if (ex instanceof Exception) {
                throw (Exception)ex;
            }
            throw new CloudEventException(ex);
        }
    }

    public static void subscribe(MqttClient client, String eventChannelName, CloudEventObserverManger observerManger) throws MqttException {
        String[] topicAry = observerManger.topicAll().toArray(new String[0]);
        int[] topicQos = new int[topicAry.length];
        IMqttMessageListener[] topicListener = new IMqttMessageListener[topicAry.length];
        int len = topicQos.length;
        for (int i = 0; i < len; ++i) {
            EventObserver eventObserver = observerManger.getByTopic(topicAry[i]);
            topicQos[i] = eventObserver.getQos();
            topicListener[i] = new MqttMessageListenerImpl(eventChannelName, (CloudEventHandler)eventObserver);
        }
        client.subscribe(topicAry, topicQos, topicListener);
    }
}

