/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.solon.plugins;

import com.baomidou.mybatisplus.solon.plugins.inner.InnerInterceptor;
import com.baomidou.mybatisplus.solon.toolkit.PropertyMapper;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.noear.solon.core.util.ClassUtil;

@Intercepts(value={@Signature(type=StatementHandler.class, method="prepare", args={Connection.class, Integer.class}), @Signature(type=StatementHandler.class, method="getBoundSql", args={}), @Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class, CacheKey.class, BoundSql.class})})
public class MybatisPlusInterceptor
implements Interceptor {
    private List<InnerInterceptor> interceptors = new ArrayList<InnerInterceptor>();

    public Object intercept(Invocation invocation) throws Throwable {
        block10: {
            Object[] args;
            Object target;
            block9: {
                target = invocation.getTarget();
                args = invocation.getArgs();
                if (!(target instanceof Executor)) break block9;
                Executor executor = (Executor)target;
                Object parameter = args[1];
                boolean isUpdate = args.length == 2;
                MappedStatement ms = (MappedStatement)args[0];
                if (!isUpdate && ms.getSqlCommandType() == SqlCommandType.SELECT) {
                    RowBounds rowBounds = (RowBounds)args[2];
                    ResultHandler resultHandler = (ResultHandler)args[3];
                    BoundSql boundSql = args.length == 4 ? ms.getBoundSql(parameter) : (BoundSql)args[5];
                    for (InnerInterceptor query : this.interceptors) {
                        if (!query.willDoQuery(executor, ms, parameter, rowBounds, resultHandler, boundSql)) {
                            return Collections.emptyList();
                        }
                        query.beforeQuery(executor, ms, parameter, rowBounds, resultHandler, boundSql);
                    }
                    CacheKey cacheKey = executor.createCacheKey(ms, parameter, rowBounds, boundSql);
                    return executor.query(ms, parameter, rowBounds, resultHandler, cacheKey, boundSql);
                }
                if (!isUpdate) break block10;
                for (InnerInterceptor update : this.interceptors) {
                    if (!update.willDoUpdate(executor, ms, parameter)) {
                        return -1;
                    }
                    update.beforeUpdate(executor, ms, parameter);
                }
                break block10;
            }
            StatementHandler sh = (StatementHandler)target;
            if (null == args) {
                for (InnerInterceptor innerInterceptor : this.interceptors) {
                    innerInterceptor.beforeGetBoundSql(sh);
                }
            } else {
                Connection connections = (Connection)args[0];
                Integer transactionTimeout = (Integer)args[1];
                for (InnerInterceptor innerInterceptor : this.interceptors) {
                    innerInterceptor.beforePrepare(sh, connections, transactionTimeout);
                }
            }
        }
        return invocation.proceed();
    }

    public Object plugin(Object target) {
        if (target instanceof Executor || target instanceof StatementHandler) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    public void addInnerInterceptor(InnerInterceptor innerInterceptor) {
        this.interceptors.add(innerInterceptor);
    }

    public List<InnerInterceptor> getInterceptors() {
        return Collections.unmodifiableList(this.interceptors);
    }

    public void setProperties(Properties properties) {
        PropertyMapper pm = PropertyMapper.newInstance(properties);
        Map<String, Properties> group = pm.group("@");
        group.forEach((k, v) -> {
            InnerInterceptor innerInterceptor = (InnerInterceptor)ClassUtil.newInstance((String)k);
            innerInterceptor.setProperties((Properties)v);
            this.addInnerInterceptor(innerInterceptor);
        });
    }

    public void setInterceptors(List<InnerInterceptor> interceptors) {
        this.interceptors = interceptors;
    }
}

