/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.solon.toolkit;

import com.baomidou.mybatisplus.core.enums.SqlMethod;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.ExceptionUtils;
import com.baomidou.mybatisplus.core.toolkit.GlobalConfigUtils;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.reflection.ExceptionUtil;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.noear.solon.data.tran.TranUtils;

public class SqlHelper {
    public static SqlSessionFactory FACTORY;

    public static SqlSession sqlSession(Class<?> clazz) {
        return SqlHelper.sqlSessionFactory(clazz).openSession();
    }

    public static SqlSession sqlSessionBatch(Class<?> clazz) {
        return SqlHelper.sqlSessionFactory(clazz).openSession(ExecutorType.BATCH);
    }

    public static SqlSessionFactory sqlSessionFactory(Class<?> clazz) {
        return GlobalConfigUtils.currentSessionFactory(clazz);
    }

    public static TableInfo table(Class<?> clazz) {
        TableInfo tableInfo = TableInfoHelper.getTableInfo(clazz);
        Assert.notNull((Object)tableInfo, (String)"Error: Cannot execute table Method, ClassGenericType not found.", (Object[])new Object[0]);
        return tableInfo;
    }

    public static boolean retBool(Integer result) {
        return null != result && result >= 1;
    }

    public static boolean retBool(Long result) {
        return null != result && result >= 1L;
    }

    public static long retCount(Long result) {
        return null == result ? 0L : result;
    }

    public static <E> E getObject(Log log, List<E> list) {
        return SqlHelper.getObject(() -> log, list);
    }

    public static <E> E getObject(Supplier<Log> supplier, List<E> list) {
        if (CollectionUtils.isNotEmpty(list)) {
            int size = list.size();
            if (size > 1) {
                Log log = supplier.get();
                log.warn(String.format("Warn: execute Method There are  %s results.", size));
            }
            return list.get(0);
        }
        return null;
    }

    public static boolean executeBatch(Class<?> entityClass, Log log, Consumer<SqlSession> consumer) {
        SqlSessionFactory sqlSessionFactory = SqlHelper.sqlSessionFactory(entityClass);
        boolean transaction = TranUtils.inTrans();
        SqlSession sqlSession = sqlSessionFactory.openSession(ExecutorType.BATCH);
        if (!transaction) {
            log.warn("SqlSession [" + sqlSession + "] Transaction not enabled");
        }
        try {
            consumer.accept(sqlSession);
            sqlSession.commit(!transaction);
            boolean bl = true;
            return bl;
        }
        catch (RuntimeException t) {
            throw t;
        }
        catch (Throwable t) {
            sqlSession.rollback();
            Throwable unwrapped = ExceptionUtil.unwrapThrowable((Throwable)t);
            if (unwrapped instanceof RuntimeException) {
                throw (RuntimeException)unwrapped;
            }
            throw ExceptionUtils.mpe((Throwable)unwrapped);
        }
        finally {
            sqlSession.close();
        }
    }

    public static <E> boolean executeBatch(Class<?> entityClass, Log log, Collection<E> list, int batchSize, BiConsumer<SqlSession, E> consumer) {
        Assert.isFalse((batchSize < 1 ? 1 : 0) != 0, (String)"batchSize must not be less than one", (Object[])new Object[0]);
        return !CollectionUtils.isEmpty(list) && SqlHelper.executeBatch(entityClass, log, sqlSession -> {
            int size = list.size();
            int idxLimit = Math.min(batchSize, size);
            int i = 1;
            for (Object element : list) {
                consumer.accept((SqlSession)sqlSession, element);
                if (i == idxLimit) {
                    sqlSession.flushStatements();
                    idxLimit = Math.min(idxLimit + batchSize, size);
                }
                ++i;
            }
        });
    }

    public static <E> boolean saveOrUpdateBatch(Class<?> entityClass, Class<?> mapper, Log log, Collection<E> list, int batchSize, BiPredicate<SqlSession, E> predicate, BiConsumer<SqlSession, E> consumer) {
        String sqlStatement = SqlHelper.getSqlStatement(mapper, SqlMethod.INSERT_ONE);
        return SqlHelper.executeBatch(entityClass, log, list, batchSize, (sqlSession, entity) -> {
            if (predicate.test((SqlSession)sqlSession, (Object)entity)) {
                sqlSession.insert(sqlStatement, entity);
            } else {
                consumer.accept((SqlSession)sqlSession, (Object)entity);
            }
        });
    }

    public static String getSqlStatement(Class<?> mapper, SqlMethod sqlMethod) {
        return mapper.getName() + "." + sqlMethod.getMethod();
    }

    @Deprecated
    public static <T> BaseMapper<T> getMapper(Class<T> entityClass) {
        BaseMapper mapper;
        Optional.ofNullable(entityClass).orElseThrow(() -> ExceptionUtils.mpe((String)"entityClass can't be null!", (Object[])new Object[0]));
        TableInfo tableInfo = Optional.ofNullable(TableInfoHelper.getTableInfo(entityClass)).orElseThrow(() -> ExceptionUtils.mpe((String)"Can not find TableInfo from Class: \"%s\".", (Object[])new Object[]{entityClass.getName()}));
        String namespace = tableInfo.getCurrentNamespace();
        Configuration configuration = tableInfo.getConfiguration();
        SqlSession sqlSession = SqlHelper.sqlSession(entityClass);
        try {
            mapper = (BaseMapper)configuration.getMapper(Class.forName(namespace), sqlSession);
        }
        catch (ClassNotFoundException e) {
            throw ExceptionUtils.mpe((Throwable)e);
        }
        return mapper;
    }

    public static <T> BaseMapper<T> getMapper(Class<T> entityClass, SqlSession sqlSession) {
        Optional.ofNullable(entityClass).orElseThrow(() -> ExceptionUtils.mpe((String)"entityClass can't be null!", (Object[])new Object[0]));
        TableInfo tableInfo = Optional.ofNullable(TableInfoHelper.getTableInfo(entityClass)).orElseThrow(() -> ExceptionUtils.mpe((String)"Can not find TableInfo from Class: \"%s\".", (Object[])new Object[]{entityClass.getName()}));
        try {
            Configuration configuration = tableInfo.getConfiguration();
            return (BaseMapper)configuration.getMapper(Class.forName(tableInfo.getCurrentNamespace()), sqlSession);
        }
        catch (ClassNotFoundException e) {
            throw ExceptionUtils.mpe((Throwable)e);
        }
    }
}

