/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.solon.ddl;

import com.baomidou.mybatisplus.solon.ddl.DdlHelper;
import com.baomidou.mybatisplus.solon.ddl.history.IDdlGenerator;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import javax.sql.DataSource;

public class DdlScript {
    private DataSource dataSource;
    private IDdlGenerator ddlGenerator;
    private boolean autoCommit;

    public DdlScript(DataSource dataSource) {
        this(dataSource, null);
    }

    public DdlScript(DataSource dataSource, IDdlGenerator ddlGenerator) {
        this(dataSource, ddlGenerator, false);
    }

    public DdlScript(DataSource dataSource, IDdlGenerator ddlGenerator, boolean autoCommit) {
        this.dataSource = dataSource;
        this.ddlGenerator = ddlGenerator;
        this.autoCommit = autoCommit;
    }

    public void run(List<String> sqlFiles) {
        this.run(sqlFiles, this.autoCommit);
    }

    public void run(List<String> sqlFiles, boolean autoCommit) {
        DdlHelper.runScript(this.ddlGenerator, this.dataSource, sqlFiles, autoCommit);
    }

    public void run(String sqlScript) throws Exception {
        this.run(new StringReader(sqlScript));
    }

    public void run(Reader reader) throws Exception {
        this.run(reader, this.autoCommit);
    }

    public void run(Reader reader, boolean autoCommit) throws Exception {
        DdlHelper.getScriptRunner(this.dataSource.getConnection(), autoCommit).runScript(reader);
    }
}

