/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.solon.ddl.history;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.solon.ddl.history.IDdlGenerator;
import java.util.function.Function;

public class PostgreDdlGenerator
implements IDdlGenerator {
    public static IDdlGenerator newInstance() {
        return new PostgreDdlGenerator();
    }

    @Override
    public boolean existTable(String databaseName, Function<String, Boolean> executeFunction) {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT COUNT(1) AS NUM from INFORMATION_SCHEMA.TABLES WHERE TABLE_NAME='ddl_history' AND TABLE_TYPE='BASE TABLE'");
        if (StringUtils.isNotBlank((CharSequence)this.getSchema())) {
            sql.append(" AND TABLE_SCHEMA='").append(this.getSchema()).append("'");
        }
        return executeFunction.apply(sql.toString());
    }

    @Override
    public String getDdlHistory() {
        return "\"" + this.getSchema() + "\".\"ddl_history\"";
    }

    @Override
    public String createDdlHistory() {
        StringBuffer sql = new StringBuffer();
        String ddlHistory = this.getDdlHistory();
        sql.append("CREATE TABLE IF NOT EXISTS ").append(ddlHistory).append(" (");
        sql.append("\"script\" varchar(500) NOT NULL,");
        sql.append("\"type\" varchar(30) NOT NULL,");
        sql.append("\"version\" varchar(30) NOT NULL");
        sql.append(");");
        sql.append("COMMENT ON COLUMN ").append(ddlHistory).append(".\"script\" IS '\u811a\u672c';");
        sql.append("COMMENT ON COLUMN ").append(ddlHistory).append(".\"type\" IS '\u7c7b\u578b';");
        sql.append("COMMENT ON COLUMN ").append(ddlHistory).append(".\"version\" IS '\u7248\u672c';");
        sql.append("COMMENT ON TABLE ").append(ddlHistory).append(" IS 'DDL \u7248\u672c';");
        return sql.toString();
    }

    protected String getSchema() {
        return "public";
    }
}

