/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.extend.mybatis;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.noear.solon.XApp;
import org.noear.solon.XUtil;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.extend.mybatis.SqlFactoryAdapter;
import org.noear.solon.extend.mybatis.SqlSessionHolder;
import org.noear.solon.extend.mybatis.SqlSessionInterceptor;

class DbManager {
    private static DbManager _global = new DbManager();
    private Map<String, SqlSessionHolder> dbMap = new ConcurrentHashMap<String, SqlSessionHolder>();

    DbManager() {
    }

    public static DbManager global() {
        return _global;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SqlSessionHolder get(BeanWrap bw) {
        SqlSessionHolder db = this.dbMap.get(bw.name());
        if (db == null) {
            String string = bw.name().intern();
            synchronized (string) {
                db = this.dbMap.get(bw.name());
                if (db == null) {
                    db = this.buildSqlSessionFactory(bw);
                    this.dbMap.putIfAbsent(bw.name(), db);
                    if (bw.typed()) {
                        this.dbMap.putIfAbsent("", db);
                    }
                }
            }
        }
        return db;
    }

    public void reg(BeanWrap bw) {
        this.get(bw);
    }

    private SqlSessionHolder buildSqlSessionFactory(BeanWrap bw) {
        SqlFactoryAdapter adapter = XUtil.isEmpty((String)bw.name()) ? new SqlFactoryAdapter(bw) : new SqlFactoryAdapter(bw, (Properties)XApp.cfg().getProp("mybatis." + bw.name()));
        SqlSessionFactory factory = adapter.getFactory();
        SqlSessionHolder holder = new SqlSessionHolder(factory, this.buildSqlSessionProxy(factory));
        adapter.mapperScan(holder);
        return holder;
    }

    private SqlSession buildSqlSessionProxy(SqlSessionFactory factory) {
        return (SqlSession)Proxy.newProxyInstance(factory.getClass().getClassLoader(), new Class[]{SqlSession.class}, (InvocationHandler)new SqlSessionInterceptor(factory));
    }
}

