/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.extend.mybatis;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.function.BiConsumer;
import javax.sql.DataSource;
import org.apache.ibatis.builder.xml.XMLMapperBuilder;
import org.apache.ibatis.executor.ErrorContext;
import org.apache.ibatis.io.Resources;
import org.apache.ibatis.mapping.Environment;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.SqlSessionFactoryBuilder;
import org.apache.ibatis.transaction.TransactionFactory;
import org.apache.ibatis.transaction.jdbc.JdbcTransactionFactory;
import org.noear.solon.XApp;
import org.noear.solon.XUtil;
import org.noear.solon.core.Aop;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.core.XEventBus;
import org.noear.solon.core.XScaner;
import org.noear.solon.extend.mybatis.SqlSessionHolder;

class SqlFactoryAdapter {
    protected Configuration config;
    protected SqlSessionFactory factory;
    protected List<String> mappers = new ArrayList<String>();
    protected BeanWrap dsWrap;
    protected static int environmentIndex = 0;

    public SqlFactoryAdapter(BeanWrap dsWrap) {
        this(dsWrap, (Properties)XApp.cfg().getProp("mybatis"));
    }

    public SqlFactoryAdapter(BeanWrap dsWrap, Properties props) {
        this.dsWrap = dsWrap;
        DataSource dataSource = (DataSource)dsWrap.raw();
        String environment_id = props.getProperty("environment");
        if (XUtil.isEmpty((String)environment_id)) {
            environment_id = "solon-" + environmentIndex++;
        }
        JdbcTransactionFactory tf = new JdbcTransactionFactory();
        Environment environment = new Environment(environment_id, (TransactionFactory)tf, dataSource);
        this.config = new Configuration(environment);
        XEventBus.push((Object)this.config);
        this.init0(this.config, props);
    }

    private void init0(Configuration config, Properties props) {
        if (props != null) {
            props.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
                if (k instanceof String && v instanceof String) {
                    String key = (String)k;
                    String val = (String)v;
                    if (key.startsWith("typeAliases[")) {
                        if (key.endsWith(".class")) {
                            Class clz = XUtil.loadClass((String)val.substring(0, val.length() - 6));
                            if (clz != null) {
                                this.cfg().getTypeAliasRegistry().registerAlias(clz);
                            }
                        } else {
                            this.cfg().getTypeAliasRegistry().registerAliases(val);
                        }
                    }
                }
            }));
            props.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
                if (k instanceof String && v instanceof String) {
                    String key = (String)k;
                    String val = (String)v;
                    if (key.startsWith("mappers[")) {
                        if (val.endsWith(".xml")) {
                            this.addMappersByXml(val);
                            this.mappers.add(val);
                        } else if (val.endsWith(".class")) {
                            Class clz = XUtil.loadClass((String)val.substring(0, val.length() - 6));
                            if (clz != null) {
                                this.cfg().addMapper(clz);
                                this.mappers.add(val);
                            }
                        } else {
                            this.cfg().addMappers(val);
                            this.mappers.add(val);
                        }
                    }
                }
            }));
            if (this.mappers.size() == 0) {
                throw new RuntimeException("Please add the mappers configuration!");
            }
        }
    }

    private void addMappersByXml(String val) {
        try {
            ErrorContext.instance().resource(val);
            InputStream stream = Resources.getResourceAsStream((String)val);
            XMLMapperBuilder mapperParser = new XMLMapperBuilder(stream, this.cfg(), val, this.cfg().getSqlFragments());
            mapperParser.parse();
        }
        catch (Throwable ex) {
            XEventBus.push((Object)ex);
        }
    }

    public Configuration cfg() {
        return this.config;
    }

    public SqlSessionFactory getFactory() {
        if (this.factory == null) {
            this.factory = new SqlSessionFactoryBuilder().build(this.config);
        }
        return this.factory;
    }

    public SqlFactoryAdapter mapperScan(SqlSessionHolder proxy) {
        for (String val : this.mappers) {
            this.mapperScan0(proxy, val);
        }
        return this;
    }

    public SqlFactoryAdapter mapperScan(SqlSessionHolder proxy, String basePackages) {
        this.mapperScan0(proxy, basePackages);
        return this;
    }

    private void mapperScan0(SqlSessionHolder proxy, String val) {
        if (!val.endsWith(".xml")) {
            if (val.endsWith(".class")) {
                Class clz = XUtil.loadClass((String)val.substring(0, val.length() - 6));
                this.mapperBindDo(proxy, clz);
            } else {
                String dir = val.replace('.', '/');
                this.mapperScanDo(proxy, dir);
            }
        }
    }

    private void mapperScanDo(SqlSessionHolder proxy, String dir) {
        XScaner.scan((String)dir, n -> n.endsWith(".class")).stream().map(name -> {
            String className = name.substring(0, name.length() - 6);
            return XUtil.loadClass((String)className.replace("/", "."));
        }).forEach(clz -> this.mapperBindDo(proxy, (Class<?>)clz));
    }

    private void mapperBindDo(SqlSessionHolder proxy, Class<?> clz) {
        if (clz != null && clz.isInterface()) {
            Object mapper = proxy.getMapper(clz);
            Aop.context().putWrap(clz, Aop.wrap(clz, mapper));
        }
    }
}

