/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.extend.mybatis;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import javax.sql.DataSource;
import org.apache.ibatis.reflection.ExceptionUtil;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.noear.solon.core.XTranUtils;

public class SqlSessionInterceptor
implements InvocationHandler {
    private SqlSessionFactory factory;

    public SqlSessionInterceptor(SqlSessionFactory factory) {
        this.factory = factory;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        SqlSession session = this.factory.openSession(XTranUtils.getConnection((DataSource)this.factory.getConfiguration().getEnvironment().getDataSource()));
        Object unwrapped = null;
        try {
            Object result;
            unwrapped = result = method.invoke((Object)session, args);
        }
        catch (Throwable ex) {
            unwrapped = ExceptionUtil.unwrapThrowable((Throwable)ex);
            throw (Throwable)unwrapped;
        }
        finally {
            if (session != null && !XTranUtils.inTrans()) {
                session.close();
            }
        }
        return unwrapped;
    }
}

