/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.extend.mybatis.integration;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.function.BiConsumer;
import javax.sql.DataSource;
import org.apache.ibatis.builder.xml.XMLMapperBuilder;
import org.apache.ibatis.executor.ErrorContext;
import org.apache.ibatis.io.Resources;
import org.apache.ibatis.mapping.Environment;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.SqlSessionFactoryBuilder;
import org.apache.ibatis.transaction.TransactionFactory;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.core.Aop;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.extend.mybatis.MybatisAdapter;
import org.noear.solon.extend.mybatis.integration.MybatisPlugins;
import org.noear.solon.extend.mybatis.tran.SolonManagedTransactionFactory;

public class MybatisAdapterDefault
implements MybatisAdapter {
    protected final BeanWrap dsWrap;
    protected Configuration config;
    protected SqlSessionFactory factory;
    protected List<String> mappers = new ArrayList<String>();
    protected SqlSessionFactoryBuilder factoryBuilder;

    protected MybatisAdapterDefault(BeanWrap dsWrap) {
        this(dsWrap, (Properties)Solon.cfg().getProp("mybatis"));
    }

    protected MybatisAdapterDefault(BeanWrap dsWrap, Properties props) {
        this.dsWrap = dsWrap;
        this.factoryBuilder = new SqlSessionFactoryBuilder();
        DataSource dataSource = (DataSource)dsWrap.raw();
        String dataSourceId = "ds-" + (dsWrap.name() == null ? "" : dsWrap.name());
        SolonManagedTransactionFactory tf = new SolonManagedTransactionFactory();
        Environment environment = new Environment(dataSourceId, (TransactionFactory)tf, dataSource);
        this.initConfiguration(environment);
        for (Interceptor i : MybatisPlugins.getInterceptors()) {
            this.config.addInterceptor(i);
        }
        EventBus.push((Object)this.config);
        this.init0(props);
        Aop.getAsyn(SqlSessionFactoryBuilder.class, bw -> {
            this.factoryBuilder = (SqlSessionFactoryBuilder)bw.raw();
        });
    }

    protected void initConfiguration(Environment environment) {
        this.config = new Configuration(environment);
    }

    private void init0(Properties props) {
        if (props != null) {
            props.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
                if (k instanceof String && v instanceof String) {
                    String key = (String)k;
                    String valStr = (String)v;
                    if (key.startsWith("typeAliases[") || key.equals("typeAliases")) {
                        for (String val : valStr.split(",")) {
                            if ((val = val.trim()).length() == 0) continue;
                            if (val.endsWith(".class")) {
                                Class clz = Utils.loadClass((String)val.substring(0, val.length() - 6));
                                if (clz == null) continue;
                                this.getConfiguration().getTypeAliasRegistry().registerAlias(clz);
                                continue;
                            }
                            this.getConfiguration().getTypeAliasRegistry().registerAliases(val);
                        }
                    }
                }
            }));
            props.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
                if (k instanceof String && v instanceof String) {
                    String key = (String)k;
                    String valStr = (String)v;
                    if (key.startsWith("mappers[") || key.equals("mappers")) {
                        for (String val : valStr.split(",")) {
                            if ((val = val.trim()).length() == 0) continue;
                            if (val.endsWith(".xml")) {
                                this.addMappersByXml(val);
                                this.mappers.add(val);
                                continue;
                            }
                            if (val.endsWith(".class")) {
                                Class clz = Utils.loadClass((String)val.substring(0, val.length() - 6));
                                if (clz == null) continue;
                                this.getConfiguration().addMapper(clz);
                                this.mappers.add(val);
                                continue;
                            }
                            this.getConfiguration().addMappers(val);
                            this.mappers.add(val);
                        }
                    }
                }
            }));
            if (this.mappers.size() == 0) {
                throw new RuntimeException("Please add the mappers configuration!");
            }
        }
    }

    private void addMappersByXml(String val) {
        try {
            ErrorContext.instance().resource(val);
            InputStream stream = Resources.getResourceAsStream((String)val);
            XMLMapperBuilder mapperParser = new XMLMapperBuilder(stream, this.getConfiguration(), val, this.getConfiguration().getSqlFragments());
            mapperParser.parse();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Configuration getConfiguration() {
        return this.config;
    }

    @Override
    public SqlSessionFactory getFactory() {
        if (this.factory == null) {
            this.factory = this.factoryBuilder.build(this.getConfiguration());
        }
        return this.factory;
    }

    @Override
    public List<String> getMappers() {
        return this.mappers;
    }
}

