/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.extend.mybatis.integration;

import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.extend.mybatis.MybatisAdapter;
import org.noear.solon.extend.mybatis.MybatisAdapterFactory;
import org.noear.solon.extend.mybatis.integration.MybatisAdapterFactoryDefault;
import org.noear.solon.extend.mybatis.integration.MybatisMapperScanner;

public class MybatisAdapterManager {
    private static MybatisAdapterFactory adapterFactory = new MybatisAdapterFactoryDefault();
    private static Map<String, MybatisAdapter> dbMap = new ConcurrentHashMap<String, MybatisAdapter>();

    public static void setAdapterFactory(MybatisAdapterFactory adapterFactory) {
        MybatisAdapterManager.adapterFactory = adapterFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MybatisAdapter get(BeanWrap bw) {
        MybatisAdapter db = dbMap.get(bw.name());
        if (db == null) {
            String string = bw.name().intern();
            synchronized (string) {
                db = dbMap.get(bw.name());
                if (db == null) {
                    db = MybatisAdapterManager.buildAdapter(bw);
                    dbMap.putIfAbsent(bw.name(), db);
                    if (bw.typed()) {
                        dbMap.putIfAbsent("", db);
                    }
                }
            }
        }
        return db;
    }

    public static void register(BeanWrap bw) {
        MybatisAdapterManager.get(bw);
    }

    private static MybatisAdapter buildAdapter(BeanWrap bw) {
        MybatisAdapter adapter = Utils.isEmpty((String)bw.name()) ? adapterFactory.create(bw) : adapterFactory.create(bw, (Properties)Solon.cfg().getProp("mybatis." + bw.name()));
        MybatisMapperScanner.mapperScan(adapter);
        return adapter;
    }
}

