/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.extend.mybatis.integration;

import org.noear.solon.Utils;
import org.noear.solon.core.Aop;
import org.noear.solon.core.util.ScanUtil;
import org.noear.solon.extend.mybatis.MybatisAdapter;

class MybatisMapperScanner {
    MybatisMapperScanner() {
    }

    protected static void mapperScan(MybatisAdapter adapter) {
        for (String val : adapter.getMappers()) {
            MybatisMapperScanner.mapperScan0(adapter, val);
        }
    }

    private static void mapperScan0(MybatisAdapter adapter, String val) {
        if (!val.endsWith(".xml")) {
            if (val.endsWith(".class")) {
                Class clz = Utils.loadClass((String)val.substring(0, val.length() - 6));
                MybatisMapperScanner.mapperBindDo(adapter, clz);
            } else {
                String dir = val.replace('.', '/');
                MybatisMapperScanner.mapperScanDo(adapter, dir);
            }
        }
    }

    private static void mapperScanDo(MybatisAdapter adapter, String dir) {
        ScanUtil.scan((String)dir, n -> n.endsWith(".class")).stream().map(name -> {
            String className = name.substring(0, name.length() - 6);
            return Utils.loadClass((String)className.replace("/", "."));
        }).forEach(clz -> MybatisMapperScanner.mapperBindDo(adapter, clz));
    }

    private static void mapperBindDo(MybatisAdapter adapter, Class<?> clz) {
        if (clz != null && clz.isInterface()) {
            Object mapper = adapter.getMapperProxy(clz);
            Aop.context().putWrap(clz, Aop.wrap(clz, (Object)mapper));
        }
    }
}

