/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.extend.mybatis.tran;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.ibatis.transaction.Transaction;
import org.noear.solon.data.tran.TranUtils;

public class SolonManagedTransaction
implements Transaction {
    DataSource dataSource;
    Connection connection;

    public SolonManagedTransaction(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public Connection getConnection() throws SQLException {
        this.connection = TranUtils.getConnection((DataSource)this.dataSource);
        return this.connection;
    }

    public void commit() throws SQLException {
        if (this.connection != null && !TranUtils.inTrans() && !this.connection.getAutoCommit()) {
            this.connection.commit();
        }
    }

    public void rollback() throws SQLException {
        if (this.connection != null && !TranUtils.inTrans() && !this.connection.getAutoCommit()) {
            this.connection.rollback();
        }
    }

    public void close() throws SQLException {
        if (this.connection != null && !TranUtils.inTrans()) {
            this.connection.setAutoCommit(true);
            this.connection.close();
        }
    }

    public Integer getTimeout() throws SQLException {
        return null;
    }
}

