/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.solon.integration;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.ibatis.builder.xml.XMLMapperBuilder;
import org.apache.ibatis.executor.ErrorContext;
import org.apache.ibatis.io.Resources;
import org.apache.ibatis.mapping.Environment;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.SqlSessionFactoryBuilder;
import org.apache.ibatis.solon.MybatisAdapter;
import org.apache.ibatis.solon.integration.MybatisPluginManager;
import org.apache.ibatis.solon.integration.MybatisPluginUtils;
import org.apache.ibatis.solon.tran.SolonManagedTransactionFactory;
import org.apache.ibatis.transaction.TransactionFactory;
import org.apache.ibatis.type.TypeHandler;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.core.Props;
import org.noear.solon.core.VarHolder;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.core.util.LogUtil;
import org.noear.solon.core.util.ResourceUtil;

public class MybatisAdapterDefault
implements MybatisAdapter {
    protected final BeanWrap dsWrap;
    protected final Props dsProps;
    protected Configuration config;
    protected SqlSessionFactory factory;
    protected List<String> mappers = new ArrayList<String>();
    protected SqlSessionFactoryBuilder factoryBuilder;

    protected MybatisAdapterDefault(BeanWrap dsWrap) {
        this(dsWrap, Solon.cfg().getProp("mybatis"));
    }

    protected MybatisAdapterDefault(BeanWrap dsWrap, Props dsProps) {
        this.dsWrap = dsWrap;
        this.dsProps = dsProps == null ? new Props() : dsProps;
        this.factoryBuilder = new SqlSessionFactoryBuilder();
        DataSource dataSource = this.getDataSource();
        String dataSourceId = dsWrap.name();
        if (Utils.isEmpty((String)dataSourceId)) {
            dataSourceId = "_main";
        }
        SolonManagedTransactionFactory tf = new SolonManagedTransactionFactory();
        Environment environment = new Environment(dataSourceId, (TransactionFactory)tf, dataSource);
        this.initConfiguration(environment);
        for (Interceptor i : MybatisPluginManager.getInterceptors()) {
            this.config.addInterceptor(i);
        }
        dsWrap.context().lifecycle(-99, () -> dsWrap.context().beanForeach(bw -> {
            if (bw.raw() instanceof Interceptor) {
                this.config.addInterceptor((Interceptor)bw.raw());
            }
        }));
        EventBus.push((Object)this.config);
        this.initDo();
        dsWrap.context().getBeanAsync(SqlSessionFactoryBuilder.class, bean -> {
            this.factoryBuilder = bean;
        });
    }

    protected DataSource getDataSource() {
        return (DataSource)this.dsWrap.raw();
    }

    protected void initConfiguration(Environment environment) {
        this.config = new Configuration(environment);
        Props cfgProps = this.dsProps.getProp("configuration");
        if (cfgProps.size() > 0) {
            Utils.injectProperties((Object)this.config, (Properties)cfgProps);
        }
    }

    protected void initDo() {
        this.dsProps.forEach((k, v) -> {
            if (k instanceof String && v instanceof String) {
                String valNew;
                String key = (String)k;
                String valStr = (String)v;
                if (key.startsWith("typeAliases[") || key.equals("typeAliases")) {
                    for (String val : valStr.split(",")) {
                        if ((val = val.trim()).length() == 0) continue;
                        valNew = this.getClassExpr(val);
                        for (Class clz : ResourceUtil.scanClasses((String)valNew)) {
                            if (clz.isInterface()) continue;
                            this.getConfiguration().getTypeAliasRegistry().registerAlias(clz);
                        }
                    }
                }
                if (key.startsWith("typeHandlers[") || key.equals("typeHandlers")) {
                    for (String val : valStr.split(",")) {
                        if ((val = val.trim()).length() == 0) continue;
                        valNew = this.getClassExpr(val);
                        for (Class clz : ResourceUtil.scanClasses((String)valNew)) {
                            if (!TypeHandler.class.isAssignableFrom(clz)) continue;
                            this.getConfiguration().getTypeHandlerRegistry().register(clz);
                        }
                    }
                }
            }
        });
        this.dsProps.forEach((k, v) -> {
            if (k instanceof String && v instanceof String) {
                String key = (String)k;
                String valStr = (String)v;
                if (key.startsWith("mappers[") || key.equals("mappers")) {
                    for (String val : valStr.split(",")) {
                        if ((val = val.trim()).length() == 0) continue;
                        if (val.endsWith(".xml")) {
                            for (String uri : ResourceUtil.scanResources((String)val)) {
                                this.addMapperByXml(uri);
                            }
                            this.compatibilityTipsOfXml(val);
                            this.mappers.add(val);
                            continue;
                        }
                        String valNew = this.getClassExpr(val);
                        for (Class clz : ResourceUtil.scanClasses((String)valNew)) {
                            if (!clz.isInterface()) continue;
                            this.getConfiguration().addMapper(clz);
                        }
                        this.mappers.add(val);
                    }
                }
            }
        });
        if (this.mappers.size() == 0) {
            LogUtil.global().warn("Missing mappers configuration!");
        }
        if (this.config.getMapperRegistry().getMappers().size() == 0) {
            LogUtil.global().warn("Missing mapper registration, please check the mappers configuration!");
        }
        List<Interceptor> interceptors = MybatisPluginUtils.resolve(this.dsProps, "plugins");
        for (Interceptor itp : interceptors) {
            this.getConfiguration().addInterceptor(itp);
        }
    }

    @Override
    public Configuration getConfiguration() {
        return this.config;
    }

    @Override
    public SqlSessionFactory getFactory() {
        if (this.factory == null) {
            this.factory = this.factoryBuilder.build(this.getConfiguration());
        }
        return this.factory;
    }

    @Override
    public void injectTo(VarHolder varH) {
        if (MybatisAdapter.class.isAssignableFrom(varH.getType())) {
            varH.setValue((Object)this);
            return;
        }
        if (SqlSessionFactory.class.isAssignableFrom(varH.getType())) {
            varH.setValue((Object)this.getFactory());
            return;
        }
        if (Configuration.class.isAssignableFrom(varH.getType())) {
            varH.setValue((Object)this.getConfiguration());
            return;
        }
        if (varH.getType().isInterface()) {
            Object mapper = this.getMapper(varH.getType());
            varH.setValue(mapper);
            return;
        }
    }

    protected void addMapperByXml(String uri) {
        try {
            ErrorContext.instance().resource(uri);
            InputStream stream = Resources.getResourceAsStream((String)uri);
            XMLMapperBuilder mapperParser = new XMLMapperBuilder(stream, this.getConfiguration(), uri, this.getConfiguration().getSqlFragments());
            mapperParser.parse();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void compatibilityTipsOfXml(String val) {
        if (val.endsWith("*.xml") && val.indexOf("*") == val.indexOf("*.xml")) {
            LogUtil.global().warn("Mybatis-\u65b0\u6587\u4ef6\u8868\u8fbe\u5f0f\u63d0\u793a\uff1a'" + val + "' \u4e0d\u5305\u62ec\u6df1\u5ea6\u5b50\u76ee\u5f55\uff1b\u5982\u6709\u9700\u8981\u53ef\u589e\u52a0'/**/'\u6bb5");
        }
    }

    private String getClassExpr(String val) {
        if (!val.endsWith(".class") && !val.endsWith(".*")) {
            int idx = val.lastIndexOf(46);
            char acr = val.charAt(idx + 1);
            if (acr > '`') {
                return val + ".*";
            }
            return val;
        }
        return val;
    }
}

