/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.solon.integration;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ibatis.solon.MybatisAdapter;
import org.apache.ibatis.solon.MybatisAdapterFactory;
import org.apache.ibatis.solon.integration.MybatisAdapterFactoryDefault;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.core.BeanWrap;

public class MybatisAdapterManager {
    private static MybatisAdapterFactory adapterFactory = new MybatisAdapterFactoryDefault();
    private static Map<String, MybatisAdapter> dbMap = new ConcurrentHashMap<String, MybatisAdapter>();

    public static void setAdapterFactory(MybatisAdapterFactory adapterFactory) {
        MybatisAdapterManager.adapterFactory = adapterFactory;
    }

    public static MybatisAdapter getOnly(String name) {
        return dbMap.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MybatisAdapter get(BeanWrap bw) {
        MybatisAdapter db = dbMap.get(bw.name());
        if (db == null) {
            String string = bw.name().intern();
            synchronized (string) {
                db = dbMap.get(bw.name());
                if (db == null) {
                    db = MybatisAdapterManager.buildAdapter(bw);
                    dbMap.put(bw.name(), db);
                    if (bw.typed()) {
                        dbMap.put("", db);
                    }
                }
            }
        }
        return db;
    }

    public static void register(BeanWrap bw) {
        MybatisAdapterManager.get(bw);
    }

    private static MybatisAdapter buildAdapter(BeanWrap bw) {
        MybatisAdapter adapter = Utils.isEmpty((String)bw.name()) ? adapterFactory.create(bw) : adapterFactory.create(bw, Solon.cfg().getProp("mybatis." + bw.name()));
        MybatisAdapterManager.mapperBinding(bw, adapter);
        return adapter;
    }

    private static void mapperBinding(BeanWrap dsBw, MybatisAdapter adapter) {
        for (Class clz : adapter.getConfiguration().getMapperRegistry().getMappers()) {
            MybatisAdapterManager.mapperBindingDo(dsBw, adapter, clz);
        }
    }

    private static void mapperBindingDo(BeanWrap dsBw, MybatisAdapter adapter, Class<?> clz) {
        if (clz != null && clz.isInterface()) {
            Object mapper = adapter.getMapper(clz);
            dsBw.context().putWrap(clz, dsBw.context().wrap(clz, mapper));
        }
    }
}

