/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.nacos.service;

import com.alibaba.nacos.api.config.ConfigFactory;
import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.config.listener.Listener;
import com.alibaba.nacos.api.exception.NacosException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudConfigHandler;
import org.noear.solon.cloud.CloudProps;
import org.noear.solon.cloud.extend.nacos.impl.NacosConfig;
import org.noear.solon.cloud.model.Config;
import org.noear.solon.cloud.service.CloudConfigObserverEntity;
import org.noear.solon.cloud.service.CloudConfigService;

public class CloudConfigServiceNacosImp
implements CloudConfigService {
    private Map<CloudConfigHandler, CloudConfigObserverEntity> observerMap = new HashMap<CloudConfigHandler, CloudConfigObserverEntity>();
    private ConfigService real;

    public CloudConfigServiceNacosImp(CloudProps cloudProps) {
        Properties properties = NacosConfig.getServiceProperties(cloudProps, (Properties)cloudProps.getProp("config"), cloudProps.getConfigServer());
        try {
            this.real = ConfigFactory.createConfigService((Properties)properties);
        }
        catch (NacosException e) {
            throw new IllegalStateException(e);
        }
    }

    public Config pull(String group, String name) {
        if (Utils.isEmpty((String)group)) {
            group = Solon.cfg().appGroup();
        }
        try {
            group = this.groupReview(group);
            String value = this.real.getConfig(name, group, 3000L);
            return new Config(group, name, value, 0L);
        }
        catch (NacosException ex) {
            throw new RuntimeException(ex);
        }
    }

    public boolean push(String group, String name, String value) {
        if (Utils.isEmpty((String)group)) {
            group = Solon.cfg().appGroup();
        }
        try {
            group = this.groupReview(group);
            return this.real.publishConfig(name, group, value);
        }
        catch (NacosException ex) {
            throw new RuntimeException(ex);
        }
    }

    public boolean remove(String group, String name) {
        if (Utils.isEmpty((String)group)) {
            group = Solon.cfg().appGroup();
        }
        try {
            group = this.groupReview(group);
            return this.real.removeConfig(name, group);
        }
        catch (NacosException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void attention(String group, String name, CloudConfigHandler observer) {
        if (this.observerMap.containsKey(observer)) {
            return;
        }
        if (Utils.isEmpty((String)group)) {
            group = Solon.cfg().appGroup();
        }
        final CloudConfigObserverEntity entity = new CloudConfigObserverEntity(group, name, observer);
        this.observerMap.put(observer, entity);
        try {
            group = this.groupReview(group);
            this.real.addListener(name, group, new Listener(){

                public Executor getExecutor() {
                    return null;
                }

                public void receiveConfigInfo(String value) {
                    entity.handle(new Config(entity.group, entity.key, value, 0L));
                }
            });
        }
        catch (NacosException ex) {
            throw new RuntimeException(ex);
        }
    }

    private String groupReview(String group) {
        if (Utils.isEmpty((String)group)) {
            return null;
        }
        return group;
    }
}

