/*
 * Decompiled with CFR 0.152.
 */
package org.noear.nami.coder.jackson;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import org.noear.nami.Context;
import org.noear.nami.EncoderTyped;

public class JacksonTypeEncoder
implements EncoderTyped {
    public static final JacksonTypeEncoder instance = new JacksonTypeEncoder();
    ObjectMapper mapper_type = new ObjectMapper();

    public JacksonTypeEncoder() {
        this.mapper_type.enable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        this.mapper_type.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.mapper_type.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.ANY);
        this.mapper_type.activateDefaultTypingAsProperty(this.mapper_type.getPolymorphicTypeValidator(), ObjectMapper.DefaultTyping.OBJECT_AND_NON_CONCRETE, "@type");
        this.mapper_type.registerModule((Module)new JavaTimeModule());
    }

    public String enctype() {
        return "application/json-type";
    }

    public byte[] encode(Object obj) {
        try {
            return this.mapper_type.writeValueAsBytes(obj);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void pretreatment(Context ctx) {
    }
}

