/*
 * Copyright 2017-2024 noear.org and authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.noear.nami.annotation;

import java.lang.annotation.Annotation;

/**
 * @author noear
 * @since 2.3
 */
public class NamiMappingAnno implements NamiMapping {
    private Mapping anno;

    public NamiMappingAnno(Mapping anno) {
        this.anno = anno;
    }

    @Override
    public String value() {
        return anno.value();
    }

    @Override
    public String[] headers() {
        return anno.headers();
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return NamiMapping.class;
    }
}
