/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.opentracing.adapter;

import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.propagation.TextMapAdapter;
import io.opentracing.tag.Tags;
import java.util.Map;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.cloud.utils.LocalUtils;
import org.noear.solon.core.Aop;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.Filter;
import org.noear.solon.core.handle.FilterChain;

public class SolonFilterAdapter
implements Filter {
    private Tracer tracer;

    public SolonFilterAdapter() {
        Aop.getAsyn(Tracer.class, bw -> {
            this.tracer = (Tracer)bw.raw();
        });
    }

    public void doFilter(Context ctx, FilterChain chain) throws Throwable {
        if (this.tracer == null) {
            chain.doFilter(ctx);
        } else {
            Span span = this.buildSpan(ctx);
            try (Scope scope = this.tracer.activateSpan(span);){
                chain.doFilter(ctx);
            }
            catch (Throwable e) {
                span.log(Utils.throwableToString((Throwable)e));
                throw e;
            }
            finally {
                span.finish();
            }
        }
    }

    public Span buildSpan(Context ctx) {
        int port = ctx.uri().getPort();
        if (port < 1) {
            port = Solon.cfg().serverPort();
        }
        String ip = LocalUtils.getLocalAddress();
        StringBuilder spanName = new StringBuilder();
        spanName.append(ctx.path()).append(" (").append(ctx.uri().getScheme()).append(" ").append(ip).append(":").append(port).append(')');
        Tracer.SpanBuilder spanBuilder = this.tracer.buildSpan(spanName.toString());
        spanBuilder.withTag(Tags.SPAN_KIND.getKey(), "server");
        SpanContext extract = this.tracer.extract(Format.Builtin.HTTP_HEADERS, (Object)new TextMapAdapter((Map)ctx.headerMap()));
        if (extract != null) {
            spanBuilder = spanBuilder.asChildOf(extract);
        }
        Span span = spanBuilder.start();
        this.tracer.inject(span.context(), Format.Builtin.HTTP_HEADERS, (Object)new TextMapAdapter((Map)ctx.headerMap()));
        return span;
    }
}

