/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.solon;

import java.net.URL;
import java.util.Properties;
import java.util.function.Supplier;
import org.noear.solon.Utils;
import org.noear.solon.core.util.ResourceUtil;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;

public class RedissonSupplier
implements Supplier<RedissonClient> {
    private Properties properties;

    public RedissonSupplier(Properties properties) {
        this.properties = properties;
    }

    @Override
    public RedissonClient get() {
        try {
            String fileUri = this.properties.getProperty("file");
            if (Utils.isNotEmpty((String)fileUri)) {
                URL url = ResourceUtil.findResource((String)fileUri);
                Config config = Config.fromYAML((URL)url);
                return Redisson.create((Config)config);
            }
            String configTxt = this.properties.getProperty("config");
            if (Utils.isNotEmpty((String)configTxt)) {
                Config config = Config.fromYAML((String)configTxt);
                return Redisson.create((Config)config);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("The redisson configuration failed", e);
        }
        throw new IllegalStateException("Invalid redisson configuration");
    }
}

