/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.rocketmq.impl;

import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.rocketmq.client.consumer.DefaultMQPushConsumer;
import org.apache.rocketmq.client.consumer.listener.MessageListenerConcurrently;
import org.apache.rocketmq.client.exception.MQClientException;
import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudProps;
import org.noear.solon.cloud.extend.rocketmq.impl.RocketmqConfig;
import org.noear.solon.cloud.extend.rocketmq.impl.RocketmqConsumerHandler;
import org.noear.solon.cloud.service.CloudEventObserverManger;

public class RocketmqConsumer {
    private RocketmqConfig config;
    private DefaultMQPushConsumer consumer;

    public RocketmqConsumer(RocketmqConfig config) {
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(CloudProps cloudProps, CloudEventObserverManger observerManger) throws MQClientException {
        if (this.consumer != null) {
            return;
        }
        RocketmqConsumer rocketmqConsumer = this;
        synchronized (rocketmqConsumer) {
            if (this.consumer != null) {
                return;
            }
            RocketmqConsumerHandler handler = new RocketmqConsumerHandler(this.config, observerManger);
            this.consumer = new DefaultMQPushConsumer();
            this.consumer.setNamesrvAddr(this.config.getServer());
            this.consumer.setConsumerGroup(this.config.getConsumerGroup());
            if (Utils.isNotEmpty((String)this.config.getNamespace())) {
                this.consumer.setNamespace(this.config.getNamespace());
            }
            if (this.config.getConsumeThreadNums() > 0) {
                this.consumer.setConsumeThreadMax(this.config.getConsumeThreadNums());
            }
            if (this.config.getMaxReconsumeTimes() > 0) {
                this.consumer.setMaxReconsumeTimes(this.config.getMaxReconsumeTimes());
            }
            this.consumer.setConsumeMessageBatchMaxSize(1);
            this.consumer.setPullBatchSize(32);
            Properties props = cloudProps.getEventConsumerProps();
            if (props.size() > 0) {
                Utils.injectProperties((Object)this.consumer, (Properties)props);
            }
            for (Map.Entry kv : observerManger.topicTags().entrySet()) {
                String topic = (String)kv.getKey();
                Set tags = (Set)kv.getValue();
                if (tags.contains("*")) {
                    this.consumer.subscribe(topic, "*");
                    continue;
                }
                this.consumer.subscribe(topic, String.join((CharSequence)"||", tags));
            }
            this.consumer.registerMessageListener((MessageListenerConcurrently)handler);
            this.consumer.start();
        }
    }
}

