/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.rocketmq.impl;

import java.util.Properties;
import org.apache.rocketmq.acl.common.AclClientRPCHook;
import org.apache.rocketmq.acl.common.SessionCredentials;
import org.apache.rocketmq.client.exception.MQBrokerException;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.client.producer.SendStatus;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.remoting.RPCHook;
import org.apache.rocketmq.remoting.exception.RemotingException;
import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudProps;
import org.noear.solon.cloud.extend.rocketmq.impl.MessageUtil;
import org.noear.solon.cloud.extend.rocketmq.impl.RocketmqConfig;
import org.noear.solon.cloud.model.Event;

public class RocketmqProducer {
    final RocketmqConfig config;
    DefaultMQProducer producer;

    public RocketmqProducer(RocketmqConfig config) {
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(CloudProps cloudProps) throws MQClientException {
        if (this.producer != null) {
            return;
        }
        RocketmqProducer rocketmqProducer = this;
        synchronized (rocketmqProducer) {
            if (this.producer != null) {
                return;
            }
            if (Utils.isEmpty((String)this.config.getAccessKey())) {
                this.producer = new DefaultMQProducer();
            } else {
                AclClientRPCHook rpcHook = new AclClientRPCHook(new SessionCredentials(this.config.getAccessKey(), this.config.getSecretKey()));
                this.producer = new DefaultMQProducer((RPCHook)rpcHook);
            }
            this.producer.setNamesrvAddr(this.config.getServer());
            this.producer.setProducerGroup(this.config.getProducerGroup());
            if (Utils.isNotEmpty((String)this.config.getNamespace())) {
                this.producer.setNamespace(this.config.getNamespace());
            }
            if (this.config.getTimeout() > 0L) {
                this.producer.setSendMsgTimeout((int)this.config.getTimeout());
            }
            this.producer.setRetryTimesWhenSendFailed(2);
            Properties props = cloudProps.getEventProducerProps();
            if (props.size() > 0) {
                Utils.injectProperties((Object)this.producer, (Properties)props);
            }
            this.producer.start();
        }
    }

    public boolean publish(CloudProps cloudProps, Event event, String topic) throws MQClientException, RemotingException, MQBrokerException, InterruptedException {
        this.init(cloudProps);
        Message message = MessageUtil.buildNewMeaage(event, topic);
        SendResult send = this.producer.send(message);
        return send.getSendStatus().equals((Object)SendStatus.SEND_OK);
    }
}

