/*
 * Decompiled with CFR 0.152.
 */
package io.seata.solon.impl;

import io.seata.solon.annotation.GlobalTransactional;
import io.seata.tm.api.TransactionalExecutor;
import io.seata.tm.api.transaction.NoRollbackRule;
import io.seata.tm.api.transaction.RollbackRule;
import io.seata.tm.api.transaction.TransactionInfo;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.stream.Collectors;
import org.noear.solon.Utils;
import org.noear.solon.core.aspect.Invocation;

public class GlobalTransactionalExecutorImpl
implements TransactionalExecutor {
    Invocation inv;
    GlobalTransactional anno;

    public GlobalTransactionalExecutorImpl(Invocation inv, GlobalTransactional anno) {
        this.inv = inv;
        this.anno = anno;
    }

    public Object execute() throws Throwable {
        return this.inv.invoke();
    }

    public TransactionInfo getTransactionInfo() {
        TransactionInfo transactionInfo = new TransactionInfo();
        transactionInfo.setTimeOut(this.anno.timeoutMills());
        transactionInfo.setName(this.getName());
        LinkedHashSet<Object> rollbackRules = new LinkedHashSet<Object>();
        for (Class<? extends Throwable> clazz : this.anno.rollbackFor()) {
            rollbackRules.add(new RollbackRule(clazz));
        }
        for (String string : this.anno.rollbackForClassName()) {
            rollbackRules.add(new RollbackRule(string));
        }
        for (Class<? extends Throwable> clazz : this.anno.noRollbackFor()) {
            rollbackRules.add(new NoRollbackRule((Class)clazz));
        }
        for (String string : this.anno.noRollbackForClassName()) {
            rollbackRules.add(new NoRollbackRule(string));
        }
        transactionInfo.setRollbackRules(rollbackRules);
        return transactionInfo;
    }

    private String getName() {
        if (Utils.isEmpty((String)this.anno.name())) {
            String paramTypes = Arrays.stream(this.inv.method().getMethod().getParameterTypes()).map(Class::getName).collect(Collectors.joining(", ", "(", ")"));
            return this.inv.method().getMethod().getName() + paramTypes;
        }
        return this.anno.name();
    }
}

