/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.extend.shiro.aop;

import java.lang.annotation.Annotation;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.authz.annotation.RequiresRoles;
import org.apache.shiro.authz.aop.RoleAnnotationHandler;
import org.noear.solon.core.handle.Result;
import org.noear.solon.extend.shiro.aop.AbstractInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoleInterceptor
extends AbstractInterceptor<RequiresRoles> {
    private static final Logger log = LoggerFactory.getLogger(RoleInterceptor.class);
    public static final RoleInterceptor instance = new RoleInterceptor();
    private final RoleAnnotationHandler roleAnnotationHandler = new RoleAnnotationHandler();

    @Override
    public Class<RequiresRoles> type() {
        return RequiresRoles.class;
    }

    @Override
    public Result validate(RequiresRoles annotation) {
        try {
            this.roleAnnotationHandler.assertAuthorized((Annotation)annotation);
        }
        catch (AuthorizationException e) {
            log.warn(e.getMessage());
            return Result.failure((int)403, (String)e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage());
            return Result.failure((String)e.getMessage());
        }
        return Result.succeed();
    }
}

