/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.extend.shiro.aop;

import java.lang.annotation.Annotation;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.apache.shiro.authz.aop.PermissionAnnotationHandler;
import org.noear.solon.core.handle.Result;
import org.noear.solon.extend.shiro.aop.AbstractInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PermissionInterceptor
extends AbstractInterceptor<RequiresPermissions> {
    private static final Logger log = LoggerFactory.getLogger(PermissionInterceptor.class);
    public static final PermissionInterceptor instance = new PermissionInterceptor();
    private final PermissionAnnotationHandler handler = new PermissionAnnotationHandler();

    @Override
    public Class<RequiresPermissions> type() {
        return RequiresPermissions.class;
    }

    @Override
    public Result validate(RequiresPermissions annotation) {
        try {
            this.handler.assertAuthorized((Annotation)annotation);
        }
        catch (AuthorizationException e) {
            log.warn(e.getMessage());
            return Result.failure((int)403, (String)e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage());
            return Result.failure((String)e.getMessage());
        }
        return Result.succeed();
    }
}

