/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.extend.shiro.aop;

import java.lang.annotation.Annotation;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.authz.annotation.RequiresGuest;
import org.apache.shiro.authz.aop.GuestAnnotationHandler;
import org.noear.solon.core.handle.Result;
import org.noear.solon.extend.shiro.aop.AbstractInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuestInterceptor
extends AbstractInterceptor<RequiresGuest> {
    private static final Logger log = LoggerFactory.getLogger(GuestInterceptor.class);
    public static final GuestInterceptor instance = new GuestInterceptor();
    private final GuestAnnotationHandler handler = new GuestAnnotationHandler();

    @Override
    public Class<RequiresGuest> type() {
        return RequiresGuest.class;
    }

    @Override
    public Result validate(RequiresGuest annotation) {
        try {
            this.handler.assertAuthorized((Annotation)annotation);
        }
        catch (AuthorizationException e) {
            log.warn(e.getMessage());
            return Result.failure((int)403, (String)e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage());
            return Result.failure((String)e.getMessage());
        }
        return Result.succeed();
    }
}

