/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.transport.java_websocket.impl;

import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import org.java_websocket.WebSocket;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.drafts.Draft;
import org.java_websocket.drafts.Draft_6455;
import org.java_websocket.framing.Framedata;
import org.java_websocket.handshake.ServerHandshake;
import org.java_websocket.protocols.Protocol;
import org.noear.socketd.SocketD;
import org.noear.socketd.exception.SocketDConnectionException;
import org.noear.socketd.transport.client.ClientHandshakeResult;
import org.noear.socketd.transport.core.ChannelInternal;
import org.noear.socketd.transport.core.ChannelSupporter;
import org.noear.socketd.transport.core.Frame;
import org.noear.socketd.transport.core.impl.ChannelDefault;
import org.noear.socketd.transport.java_websocket.WsNioChannelAssistant;
import org.noear.socketd.transport.java_websocket.WsNioClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketClientImpl
extends WebSocketClient {
    static final Logger log = LoggerFactory.getLogger(WebSocketClientImpl.class);
    private WsNioClient client;
    private ChannelInternal channel;
    private CompletableFuture<ClientHandshakeResult> handshakeFuture;

    public WebSocketClientImpl(URI serverUri, WsNioClient client) {
        super(serverUri, (Draft)new Draft_6455(Collections.emptyList(), Collections.singletonList(new Protocol(SocketD.protocolName()))));
        this.client = client;
        this.channel = new ChannelDefault((Object)this, (ChannelSupporter)client);
    }

    public CompletableFuture<ClientHandshakeResult> getHandshakeFuture() {
        return this.handshakeFuture;
    }

    public void onWebsocketPing(WebSocket conn, Framedata f) {
    }

    public void connect() {
        this.handshakeFuture = new CompletableFuture();
        super.connect();
    }

    public void reconnect() {
        this.handshakeFuture = new CompletableFuture();
        super.reconnect();
    }

    public void onOpen(ServerHandshake serverHandshake) {
        block2: {
            try {
                this.channel.sendConnect(this.client.getConfig().getUrl(), this.client.getConfig().getMetaMap());
            }
            catch (Throwable e) {
                if (!log.isWarnEnabled()) break block2;
                log.warn("Client channel sendConnect error", e);
            }
        }
    }

    public void onMessage(String test) {
        if (log.isWarnEnabled()) {
            log.warn("Client channel unsupported onMessage(String test)");
        }
    }

    public void onMessage(ByteBuffer bytes) {
        block5: {
            try {
                Frame frame = ((WsNioChannelAssistant)this.client.getAssistant()).read(bytes);
                if (frame != null) {
                    if (frame.flag() == 11) {
                        this.channel.onOpenFuture((r, e) -> {
                            if (e == null) {
                                this.handshakeFuture.complete(new ClientHandshakeResult(this.channel, null));
                            } else {
                                this.handshakeFuture.completeExceptionally((Throwable)e);
                            }
                        });
                    }
                    this.client.getProcessor().onReceive(this.channel, frame);
                }
            }
            catch (Exception e2) {
                if (e2 instanceof SocketDConnectionException) {
                    this.handshakeFuture.complete(new ClientHandshakeResult(this.channel, (Throwable)e2));
                    return;
                }
                if (!log.isWarnEnabled()) break block5;
                log.warn("WebSocket client onMessage error", (Throwable)e2);
            }
        }
    }

    public void onClose(int i, String s, boolean b) {
        this.client.getProcessor().onClose(this.channel);
    }

    public void onError(Exception e) {
        this.client.getProcessor().onError(this.channel, (Throwable)e);
    }
}

