/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.transport.netty.tcp;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.io.IOException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.noear.socketd.exception.SocketdConnectionException;
import org.noear.socketd.transport.client.ClientConnectorBase;
import org.noear.socketd.transport.client.ClientHandshakeResult;
import org.noear.socketd.transport.client.ClientInternal;
import org.noear.socketd.transport.core.ChannelInternal;
import org.noear.socketd.transport.core.Config;
import org.noear.socketd.transport.netty.tcp.TcpNioClient;
import org.noear.socketd.transport.netty.tcp.impl.NettyChannelInitializer;
import org.noear.socketd.transport.netty.tcp.impl.NettyClientInboundHandler;
import org.noear.socketd.utils.NamedThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpNioClientConnector
extends ClientConnectorBase<TcpNioClient> {
    private static final Logger log = LoggerFactory.getLogger(TcpNioClientConnector.class);
    private ChannelFuture real;
    private NioEventLoopGroup workerGroup;

    public TcpNioClientConnector(TcpNioClient client) {
        super((ClientInternal)client);
    }

    public ChannelInternal connect() throws IOException {
        this.close();
        this.workerGroup = new NioEventLoopGroup(2, (ThreadFactory)new NamedThreadFactory("nettyTcpClientWork-"));
        try {
            Bootstrap bootstrap = new Bootstrap();
            NettyClientInboundHandler inboundHandler = new NettyClientInboundHandler((TcpNioClient)this.client);
            NettyChannelInitializer handler = new NettyChannelInitializer((Config)((TcpNioClient)this.client).getConfig(), inboundHandler);
            this.real = ((Bootstrap)((Bootstrap)((Bootstrap)bootstrap.group((EventLoopGroup)this.workerGroup)).channel(NioSocketChannel.class)).handler((ChannelHandler)handler)).connect(((TcpNioClient)this.client).getConfig().getHost(), ((TcpNioClient)this.client).getConfig().getPort()).await();
            ClientHandshakeResult handshakeResult = inboundHandler.getHandshakeFuture().get(((TcpNioClient)this.client).getConfig().getConnectTimeout(), TimeUnit.MILLISECONDS);
            if (handshakeResult.getThrowable() != null) {
                throw handshakeResult.getThrowable();
            }
            return handshakeResult.getChannel();
        }
        catch (TimeoutException e) {
            this.close();
            throw new SocketdConnectionException("Connection timeout: " + ((TcpNioClient)this.client).getConfig().getLinkUrl());
        }
        catch (Throwable e) {
            this.close();
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new SocketdConnectionException("Connection failed: " + ((TcpNioClient)this.client).getConfig().getLinkUrl(), e);
        }
    }

    public void close() {
        block4: {
            try {
                if (this.real != null) {
                    this.real.channel().close();
                }
                if (this.workerGroup != null) {
                    this.workerGroup.shutdownGracefully();
                }
            }
            catch (Throwable e) {
                if (!log.isDebugEnabled()) break block4;
                log.debug("Client connector close error", e);
            }
        }
    }
}

