/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.transport.netty.tcp.impl;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.timeout.IdleStateHandler;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLEngine;
import org.noear.socketd.transport.core.Config;
import org.noear.socketd.transport.core.Frame;
import org.noear.socketd.transport.netty.tcp.impl.IdleTimeoutHandler;
import org.noear.socketd.transport.netty.tcp.impl.NettyMessageDecoder;
import org.noear.socketd.transport.netty.tcp.impl.NettyMessageEncoder;

public class NettyChannelInitializer
extends ChannelInitializer<SocketChannel> {
    private final SimpleChannelInboundHandler<Frame> processor;
    private final Config config;

    public NettyChannelInitializer(Config config, SimpleChannelInboundHandler<Frame> processor) {
        this.processor = processor;
        this.config = config;
    }

    protected void initChannel(SocketChannel ch) throws Exception {
        ChannelPipeline pipeline = ch.pipeline();
        if (this.config.getSslContext() != null) {
            SSLEngine engine = this.config.getSslContext().createSSLEngine();
            if (!this.config.clientMode()) {
                engine.setUseClientMode(false);
                engine.setNeedClientAuth(true);
            }
            pipeline.addFirst(new ChannelHandler[]{new SslHandler(engine)});
        }
        pipeline.addLast(new ChannelHandler[]{new LengthFieldBasedFrameDecoder(0x1100000, 0, 4, -4, 0)});
        pipeline.addLast(new ChannelHandler[]{new NettyMessageEncoder(this.config)});
        pipeline.addLast(new ChannelHandler[]{new NettyMessageDecoder(this.config)});
        if (this.config.getIdleTimeout() > 0L) {
            pipeline.addLast(new ChannelHandler[]{new IdleStateHandler(this.config.getIdleTimeout(), 0L, 0L, TimeUnit.MILLISECONDS)});
            pipeline.addLast(new ChannelHandler[]{new IdleTimeoutHandler(this.config)});
        }
        pipeline.addLast(new ChannelHandler[]{this.processor});
    }
}

