/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.transport.netty.tcp.impl;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.util.AttributeKey;
import java.util.concurrent.CompletableFuture;
import org.noear.socketd.exception.SocketdConnectionException;
import org.noear.socketd.transport.client.ClientHandshakeResult;
import org.noear.socketd.transport.core.ChannelInternal;
import org.noear.socketd.transport.core.ChannelSupporter;
import org.noear.socketd.transport.core.Frame;
import org.noear.socketd.transport.core.impl.ChannelDefault;
import org.noear.socketd.transport.netty.tcp.TcpNioClient;

public class NettyClientInboundHandler
extends SimpleChannelInboundHandler<Frame> {
    private static AttributeKey<ChannelInternal> CHANNEL_KEY = AttributeKey.valueOf((String)"CHANNEL_KEY");
    private final TcpNioClient client;
    private final CompletableFuture<ClientHandshakeResult> handshakeFuture = new CompletableFuture();

    public NettyClientInboundHandler(TcpNioClient client) {
        this.client = client;
    }

    public CompletableFuture<ClientHandshakeResult> getHandshakeFuture() {
        return this.handshakeFuture;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        super.channelActive(ctx);
        ChannelDefault channel = new ChannelDefault((Object)ctx.channel(), (ChannelSupporter)this.client);
        ctx.attr(CHANNEL_KEY).set((Object)channel);
        channel.sendConnect(this.client.getConfig().getUrl(), this.client.getConfig().getMetaMap());
    }

    protected void channelRead0(ChannelHandlerContext ctx, Frame frame) throws Exception {
        ChannelInternal channel = (ChannelInternal)ctx.attr(CHANNEL_KEY).get();
        try {
            if (frame.flag() == 11) {
                channel.onOpenFuture((r, e) -> this.handshakeFuture.complete(new ClientHandshakeResult(channel, e)));
            }
            this.client.getProcessor().onReceive(channel, frame);
        }
        catch (SocketdConnectionException e2) {
            this.handshakeFuture.complete(new ClientHandshakeResult(channel, (Throwable)e2));
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
        ChannelInternal channel = (ChannelInternal)ctx.attr(CHANNEL_KEY).get();
        this.client.getProcessor().onClose(channel);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        ChannelInternal channel = (ChannelInternal)ctx.attr(CHANNEL_KEY).get();
        this.client.getProcessor().onError(channel, cause);
        ctx.close();
    }
}

