/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.transport.netty.tcp.impl;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.util.AttributeKey;
import org.noear.socketd.transport.core.ChannelInternal;
import org.noear.socketd.transport.core.ChannelSupporter;
import org.noear.socketd.transport.core.Frame;
import org.noear.socketd.transport.core.impl.ChannelDefault;
import org.noear.socketd.transport.netty.tcp.TcpNioServer;

@ChannelHandler.Sharable
public class NettyServerInboundHandler
extends SimpleChannelInboundHandler<Frame> {
    private static AttributeKey<ChannelInternal> CHANNEL_KEY = AttributeKey.valueOf((String)"CHANNEL_KEY");
    private final TcpNioServer server;

    public NettyServerInboundHandler(TcpNioServer server) {
        this.server = server;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        super.channelActive(ctx);
        ChannelDefault channel = new ChannelDefault((Object)ctx.channel(), (ChannelSupporter)this.server);
        ctx.attr(CHANNEL_KEY).set((Object)channel);
    }

    protected void channelRead0(ChannelHandlerContext ctx, Frame frame) throws Exception {
        ChannelInternal channel = (ChannelInternal)ctx.attr(CHANNEL_KEY).get();
        this.server.getProcessor().onReceive(channel, frame);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
        ChannelInternal channel = (ChannelInternal)ctx.attr(CHANNEL_KEY).get();
        this.server.getProcessor().onClose(channel);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        ChannelInternal channel = (ChannelInternal)ctx.attr(CHANNEL_KEY).get();
        this.server.getProcessor().onError(channel, cause);
        ctx.close();
    }
}

