/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.transport.netty.udp;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import org.noear.socketd.transport.core.ChannelAssistant;
import org.noear.socketd.transport.core.CodecReader;
import org.noear.socketd.transport.core.Config;
import org.noear.socketd.transport.core.Frame;
import org.noear.socketd.transport.core.codec.ByteBufferCodecReader;
import org.noear.socketd.transport.core.codec.ByteBufferCodecWriter;
import org.noear.socketd.transport.netty.udp.impl.DatagramTagert;

public class UdpNioChannelAssistant
implements ChannelAssistant<DatagramTagert> {
    private Config config;

    public UdpNioChannelAssistant(Config config) {
        this.config = config;
    }

    public void write(DatagramTagert target, Frame frame) throws IOException {
        ByteBufferCodecWriter writer = (ByteBufferCodecWriter)this.config.getCodec().write(frame, i -> new ByteBufferCodecWriter(ByteBuffer.allocate(i)));
        target.send(writer.getBuffer().array());
    }

    public Frame read(ByteBuf inBuf) throws Exception {
        if (inBuf.readableBytes() < 4) {
            return null;
        }
        inBuf.markReaderIndex();
        int len = inBuf.readInt();
        if (inBuf.readableBytes() < len - 4) {
            inBuf.resetReaderIndex();
            return null;
        }
        byte[] bytes = new byte[len - 4];
        inBuf.readBytes(bytes);
        ByteBuffer byteBuffer = ByteBuffer.allocate(len);
        byteBuffer.putInt(len);
        byteBuffer.put(bytes);
        byteBuffer.flip();
        return this.config.getCodec().read((CodecReader)new ByteBufferCodecReader(byteBuffer));
    }

    public boolean isValid(DatagramTagert target) {
        return true;
    }

    public void close(DatagramTagert target) throws IOException {
        target.close();
    }

    public InetSocketAddress getRemoteAddress(DatagramTagert target) {
        return target.getRemoteAddress();
    }

    public InetSocketAddress getLocalAddress(DatagramTagert target) {
        return target.getLocalAddress();
    }
}

