/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.transport.netty.udp.impl;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.DatagramPacket;
import io.netty.util.AttributeKey;
import java.util.concurrent.CompletableFuture;
import org.noear.socketd.transport.client.ClientHandshakeResult;
import org.noear.socketd.transport.core.ChannelInternal;
import org.noear.socketd.transport.core.ChannelSupporter;
import org.noear.socketd.transport.core.Frame;
import org.noear.socketd.transport.core.impl.ChannelDefault;
import org.noear.socketd.transport.netty.udp.UdpNioChannelAssistant;
import org.noear.socketd.transport.netty.udp.UdpNioClient;
import org.noear.socketd.transport.netty.udp.impl.DatagramTagert;

public class NettyClientInboundHandler
extends SimpleChannelInboundHandler<DatagramPacket> {
    private static AttributeKey<ChannelInternal> CHANNEL_KEY = AttributeKey.valueOf((String)"CHANNEL_KEY");
    private final UdpNioClient client;
    private final CompletableFuture<ClientHandshakeResult> handshakeFuture = new CompletableFuture();
    private ChannelInternal channel;

    public NettyClientInboundHandler(UdpNioClient client) {
        this.client = client;
    }

    public CompletableFuture<ClientHandshakeResult> getHandshakeFuture() {
        return this.handshakeFuture;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        super.channelActive(ctx);
        DatagramTagert tagert = new DatagramTagert(ctx.channel(), null, true);
        this.channel = new ChannelDefault((Object)tagert, (ChannelSupporter)this.client);
        ctx.attr(CHANNEL_KEY).set((Object)this.channel);
        this.channel.sendConnect(this.client.getConfig().getUrl(), this.client.getConfig().getMetaMap());
    }

    protected void channelRead0(ChannelHandlerContext ctx, DatagramPacket packet) throws Exception {
        ChannelInternal channel = (ChannelInternal)ctx.attr(CHANNEL_KEY).get();
        Frame frame = ((UdpNioChannelAssistant)this.client.getAssistant()).read((ByteBuf)packet.content());
        if (frame != null) {
            if (frame.flag() == 11) {
                channel.onOpenFuture((r, e) -> this.handshakeFuture.complete(new ClientHandshakeResult(channel, e)));
            }
            this.client.getProcessor().onReceive(channel, frame);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        ChannelInternal channel = (ChannelInternal)ctx.attr(CHANNEL_KEY).get();
        this.client.getProcessor().onError(channel, cause);
    }
}

